/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import tigase.component.ElementWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.DateUtil;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class GroupchatMessageModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final Criteria CRIT_CHAT_STAT = ElementCriteria.xmlns((String)"http://jabber.org/protocol/chatstates");
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();
    private boolean filterEnabled = true;
    private final HistoryProvider historyProvider;
    private final MucLogger mucLogger;

    public GroupchatMessageModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository, HistoryProvider historyProvider, MucLogger mucLogger) {
        super(config, writer, mucRepository);
        this.historyProvider = historyProvider;
        this.mucLogger = mucLogger;
        this.filterEnabled = config.isMessageFilterEnabled();
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Filtering message children is " + (this.filterEnabled ? "enabled" : "disabled"));
        }
    }

    private void addMessageToHistory(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        if (this.historyProvider != null) {
            this.historyProvider.addMessage(room, this.filterEnabled ? null : message, body, senderJid, senderNickname, time);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addMessage(room, body, senderJid, senderNickname, time);
        }
    }

    private void addSubjectChangeToHistory(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
        if (this.historyProvider != null) {
            this.historyProvider.addSubjectChange(room, this.filterEnabled ? null : message, subject, senderJid, senderNickname, time);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addSubjectChange(room, subject, senderJid, senderNickname, time);
        }
    }

    @Override
    public String[] getFeatures() {
        ArrayList<String> f = new ArrayList<String>();
        if (this.isChatStateAllowed()) {
            f.add("http://jabber.org/protocol/chatstates");
        }
        return f.toArray(new String[0]);
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isChatStateAllowed() {
        return this.allowedElements.contains(CRIT_CHAT_STAT);
    }

    @Override
    public void process(Packet packet) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)packet.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)packet.getAttributeStaticStr("to"));
            if (GroupchatMessageModule.getNicknameFromJid(JID.jidInstance((String)packet.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role role = room.getRole(nickName);
            Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
            if (!role.isSendMessagesToAll() || room.getConfig().isRoomModerated() && role == Role.visitor) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element body = null;
            Element subject = null;
            Element delay = null;
            ArrayList<Element> content = new ArrayList<Element>();
            List ccs = packet.getElement().getChildren();
            if (ccs != null) {
                block4: for (Element c : ccs) {
                    if ("delay".equals(c.getName())) {
                        delay = c;
                        continue;
                    }
                    if ("body".equals(c.getName())) {
                        body = c;
                        content.add(c);
                        continue;
                    }
                    if ("subject".equals(c.getName())) {
                        subject = c;
                        content.add(c);
                        continue;
                    }
                    if (!this.filterEnabled) {
                        content.add(c);
                        continue;
                    }
                    for (Criteria crit : this.allowedElements) {
                        if (!crit.match(c)) continue;
                        content.add(c);
                        continue block4;
                    }
                }
            }
            JID senderRoomJID = JID.jidInstance((BareJID)roomJID, (String)nickName);
            if (subject != null) {
                if (!(room.getConfig().isChangeSubject() && role == Role.participant || role.isModifySubject())) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                String msg = subject.getCData();
                room.setNewSubject(msg, nickName);
            }
            Date sendDate = delay != null && affiliation == Affiliation.owner ? DateUtil.parse(delay.getAttributeStaticStr("stamp")) : new Date();
            if (body != null) {
                this.addMessageToHistory(room, packet.getElement(), body.getCData(), senderJID, nickName, sendDate);
            }
            if (subject != null) {
                this.addSubjectChangeToHistory(room, packet.getElement(), subject.getCData(), senderJID, nickName, sendDate);
            }
            this.sendMessagesToAllOccupants(room, senderRoomJID, content.toArray(new Element[0]));
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void sendMessagesToAllOccupants(Room room, JID fromJID, Element ... content) throws TigaseStringprepException {
        for (String nickname : room.getOccupantsNicknames()) {
            Role role = room.getRole(nickname);
            if (!role.isReceiveMessages()) continue;
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                Packet message = Packet.packetInstance((Element)new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", fromJID.toString(), jid.toString()}));
                message.setXMLNS("jabber:client");
                if (content != null) {
                    for (Element sub : content) {
                        if (sub == null) continue;
                        message.getElement().addChild((XMLNodeIfc)sub);
                    }
                }
                this.writer.write(message);
            }
        }
    }

    public void setChatStateAllowed(Boolean allowed) {
        if (allowed != null && allowed.booleanValue()) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Chat state allowed");
            }
            this.allowedElements.add(CRIT_CHAT_STAT);
        } else {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Chat state disallowed");
            }
            this.allowedElements.remove(CRIT_CHAT_STAT);
        }
    }
}

