/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import tigase.component.ElementWriter;
import tigase.db.DataRepository;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractJDBCHistoryProvider;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class DerbySqlHistoryProvider
extends AbstractJDBCHistoryProvider {
    public static final String ADD_MESSAGE_QUERY_VAL = "insert into muc_history (room_name, event_type, timestamp, sender_jid, sender_nickname, body, public_event, msg) values (?, 1, ?, ?, ?, ?, ?)";
    private static final String CREATE_MUC_HISTORY_TABLE_VAL = "create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096),\n public_event BOOLEAN,\n msg varchar(32672) )";
    public static final String DELETE_MESSAGES_QUERY_VAL = "delete from muc_history where room_name=?";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from muc_history where room_name=? order by timestamp desc";
    public static final String GET_MESSAGES_SINCE_QUERY_VAL = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body, msg from muc_history where room_name=? and timestamp >= ? order by timestamp desc";

    public DerbySqlHistoryProvider(DataRepository dataRepository) {
        super(dataRepository);
    }

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, ElementWriter writer) {
        ResultSet rs;
        block20: {
            rs = null;
            String roomJID = room.getRoomJID().toString();
            try {
                PreparedStatement st;
                Integer maxStanzas = null;
                if (since != null) {
                    PreparedStatement st2;
                    PreparedStatement preparedStatement = st2 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st2.setString(1, roomJID);
                        st2.setTimestamp(2, new Timestamp(since.getTime()));
                        rs = st2.executeQuery();
                        this.processResultSet(room, senderJID, writer, maxStanzas, rs);
                        break block20;
                    }
                }
                if (maxstanzas != null) {
                    PreparedStatement st3;
                    PreparedStatement preparedStatement = st3 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st3.setString(1, roomJID);
                        maxStanzas = maxstanzas;
                        rs = st3.executeQuery();
                        this.processResultSet(room, senderJID, writer, maxStanzas, rs);
                        break block20;
                    }
                }
                if (seconds != null) {
                    PreparedStatement st4;
                    PreparedStatement preparedStatement = st4 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_SINCE_QUERY_KEY");
                    synchronized (preparedStatement) {
                        st4.setString(1, roomJID);
                        st4.setTimestamp(2, new Timestamp(new Date().getTime() - (long)(seconds * 1000)));
                        rs = st4.executeQuery();
                        this.processResultSet(room, senderJID, writer, maxStanzas, rs);
                        break block20;
                    }
                }
                PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), "GET_MESSAGES_MAXSTANZAS_QUERY_KEY");
                synchronized (preparedStatement) {
                    st.setString(1, roomJID);
                    maxStanzas = 20;
                    rs = st.executeQuery();
                    this.processResultSet(room, senderJID, writer, maxStanzas, rs);
                }
            }
            catch (Exception e) {
                try {
                    if (this.log.isLoggable(Level.SEVERE)) {
                        this.log.log(Level.SEVERE, "Can't get history", e);
                    }
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.dataRepository.release(null, rs);
                    throw throwable;
                }
            }
        }
        this.dataRepository.release(null, rs);
    }

    @Override
    public void init(Map<String, Object> props) {
        try {
            this.dataRepository.checkTable("muc_history", CREATE_MUC_HISTORY_TABLE_VAL);
            this.internalInit();
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initializing problem", e);
            }
            try {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Trying to create tables: create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096),\n public_event BOOLEAN,\n msg varchar(32672) )");
                }
                Statement st = this.dataRepository.createStatement(null);
                st.execute(CREATE_MUC_HISTORY_TABLE_VAL);
                this.internalInit();
            }
            catch (SQLException e1) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Can't initialize muc history", e1);
                }
                throw new RuntimeException(e1);
            }
        }
    }

    private void internalInit() throws SQLException {
        this.dataRepository.initPreparedStatement("ADD_MESSAGE_QUERY_KEY", ADD_MESSAGE_QUERY_VAL);
        this.dataRepository.initPreparedStatement("DELETE_MESSAGES_QUERY_KEY", DELETE_MESSAGES_QUERY_VAL);
        this.dataRepository.initPreparedStatement("GET_MESSAGES_SINCE_QUERY_KEY", GET_MESSAGES_SINCE_QUERY_VAL);
        this.dataRepository.initPreparedStatement("GET_MESSAGES_MAXSTANZAS_QUERY_KEY", GET_MESSAGES_MAXSTANZAS_QUERY_VAL);
    }

    protected void processResultSet(Room room, JID senderJID, ElementWriter writer, Integer maxStanzas, ResultSet rs) throws SQLException, TigaseStringprepException {
        Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID());
        boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
        ArrayList<Packet> result = new ArrayList<Packet>();
        for (int i = 0; rs.next() && (maxStanzas == null || maxStanzas > i); ++i) {
            String msgSenderNickname = rs.getString("sender_nickname");
            Timestamp msgTimestamp = rs.getTimestamp("timestamp");
            String msgSenderJid = rs.getString("sender_jid");
            String body = rs.getString("body");
            String msg = rs.getString("msg");
            Packet m = this.createMessage(room.getRoomJID(), senderJID, msgSenderNickname, msg, body, msgSenderJid, addRealJids, msgTimestamp);
            result.add(0, m);
        }
        for (Packet element : result) {
            writer.write(element);
        }
    }
}

