/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.util.JIDUtils;

public class NodeSubscriptions
extends tigase.pubsub.repository.NodeSubscriptions {
    protected final Map<String, UsersSubscription> changedSubs = new HashMap<String, UsersSubscription>();

    private NodeSubscriptions() {
    }

    public NodeSubscriptions(tigase.pubsub.repository.NodeSubscriptions nodeSubscriptions) {
        this.subs.putAll(nodeSubscriptions.getSubscriptionsMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addSubscriberJid(String jid, Subscription subscription) {
        String subid = Utils.createUID(jid);
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            this.changedSubs.put(bareJid, s);
        }
        return subid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeSubscription(String jid, Subscription subscription) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = (UsersSubscription)this.subs.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            Map<String, UsersSubscription> map = this.changedSubs;
            synchronized (map) {
                this.changedSubs.put(s.getJid().toString(), s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UsersSubscription get(String bareJid) {
        UsersSubscription us = null;
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            us = this.changedSubs.get(bareJid);
        }
        if (us == null && (us = (UsersSubscription)this.subs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return us;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsersSubscription[] getSubscriptions() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.subs.getAllValues());
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            result.addAll(this.changedSubs.values());
        }
        return result.toArray(new UsersSubscription[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChanged() {
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            return this.changedSubs.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() {
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            this.subs.putAll(this.changedSubs);
            this.changedSubs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetChangedFlag() {
        Map<String, UsersSubscription> map = this.changedSubs;
        synchronized (map) {
            this.changedSubs.clear();
        }
    }
}

