/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.FragmentedMap;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;

public class CachedPubSubRepository
implements IPubSubRepository {
    public static final long MAX_WRITE_DELAY = 15000L;
    private final PubSubDAO dao;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Integer maxCacheSize;
    private final Map<String, Node> nodes;
    private long nodes_added = 0L;
    private final ConcurrentSkipListSet<Node> nodesToSave = new ConcurrentSkipListSet<Node>(new NodeComparator());
    private long repo_writes = 0L;
    private final Set<String> rootCollection = new HashSet<String>();
    private LazyWriteThread tlazyWriteThread;
    private long updateSubscriptionsCalled = 0L;
    private long writingTime = 0L;

    public CachedPubSubRepository(PubSubDAO dao, Integer maxCacheSize) {
        this.dao = dao;
        this.maxCacheSize = maxCacheSize;
        this.nodes = Collections.synchronizedMap(new SizedCache(this.maxCacheSize));
        this.log.config("Initializing Cached Repository with cache size = " + (maxCacheSize == null ? "OFF" : maxCacheSize));
        this.tlazyWriteThread = this.makeLazyWriteThread(false);
        Thread x = new Thread(this.tlazyWriteThread);
        x.setName("PubSub-DataWriter");
        x.setDaemon(true);
        x.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(String name, StatisticsList stats) {
        if (this.nodes.size() > 0) {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINE);
        } else {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINEST);
        }
        if (this.nodesToSave.size() > 0) {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.INFO);
        } else {
            stats.add(name, "Unsaved nodes", this.nodesToSave.size(), Level.FINEST);
        }
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        LinkedHashMap<String, Node> tmp = null;
        Map<String, Node> map = this.nodes;
        synchronized (map) {
            tmp = new LinkedHashMap<String, Node>(this.nodes);
        }
        for (Node nd : tmp.values()) {
            subscriptionsCount += (long)nd.getNodeSubscriptions().getSubscriptionsMap().size();
            affiliationsCount += (long)nd.getNodeAffiliations().getAffiliationsMap().size();
        }
        if (this.updateSubscriptionsCalled > 0L) {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINE);
        } else {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINEST);
        }
        if (subscriptionsCount > 0L) {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINE);
        } else {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINEST);
        }
        if (affiliationsCount > 0L) {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINE);
        } else {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINEST);
        }
        if (this.repo_writes > 0L) {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINE);
        } else {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Added new nodes", this.nodes_added, Level.INFO);
        } else {
            stats.add(name, "Added new nodes", this.nodes_added, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.INFO);
        } else {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.FINEST);
        }
        if (this.nodes_added + this.repo_writes > 0L) {
            if (this.nodes_added > 0L) {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.INFO);
            } else {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.FINEST);
            }
        }
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.dao.addToRootCollection(nodeName);
        this.rootCollection.add(nodeName);
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, String ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        long start = System.currentTimeMillis();
        this.dao.createNode(nodeName, ownerJid, nodeConfig, nodeType, collection);
        tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = new tigase.pubsub.repository.cached.NodeAffiliations(NodeAffiliations.create(null));
        tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = new tigase.pubsub.repository.cached.NodeSubscriptions(NodeSubscriptions.create());
        Node node = new Node(nodeConfig, nodeAffiliations, nodeSubscriptions);
        this.nodes.put(nodeName, node);
        long end = System.currentTimeMillis();
        ++this.nodes_added;
        this.writingTime += end - start;
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.nodes.get(nodeName);
        this.dao.deleteNode(nodeName);
        if (node != null) {
            node.setDeleted(true);
        }
        this.nodes.remove(nodeName);
    }

    @Override
    public void destroy() {
        this.tlazyWriteThread.stop();
    }

    @Override
    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.nodes.remove(nodeName);
    }

    public Collection<Node> getAllNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, String bareJid) throws RepositoryException {
        return this.dao.getBuddyGroups(owner, bareJid);
    }

    @Override
    public String getBuddySubscription(BareJID owner, String buddy) throws RepositoryException {
        return this.dao.getBuddySubscription(owner, buddy);
    }

    private Node getNode(String nodeName) throws RepositoryException {
        Node node = this.nodes.get(nodeName);
        if (node == null) {
            AbstractNodeConfig nodeConfig = this.dao.getNodeConfig(nodeName);
            if (nodeConfig == null) {
                return null;
            }
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = new tigase.pubsub.repository.cached.NodeAffiliations(this.dao.getNodeAffiliations(nodeName));
            tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = new tigase.pubsub.repository.cached.NodeSubscriptions(this.dao.getNodeSubscriptions(nodeName));
            node = new Node(nodeConfig, nodeAffiliations, nodeSubscriptions);
            this.nodes.put(nodeName, node);
        }
        return node;
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        return new Items(nodeName, this.dao);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(nodeName);
        return node == null ? null : node.getNodeSubscriptions();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        String[] x;
        if (this.rootCollection.size() == 0 && (x = this.dao.getRootNodes()) != null) {
            for (String string : x) {
                this.rootCollection.add(string);
            }
        }
        return this.rootCollection.toArray(new String[this.rootCollection.size()]);
    }

    @Override
    public String[] getUserRoster(BareJID owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public void init() {
        this.log.config("Cached PubSubRepository initialising...");
    }

    private LazyWriteThread makeLazyWriteThread(boolean immediatelly) {
        return new LazyWriteThread();
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.dao.removeFromRootCollection(nodeName);
        this.rootCollection.remove(nodeName);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        Node node = this.getNode(nodeName);
        if (node != null) {
            node.configCopyFrom(nodeConfig);
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.nodesToSave.add(node);
            this.tlazyWriteThread.wakeup();
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof tigase.pubsub.repository.cached.NodeAffiliations) {
            Node node = this.getNode(nodeName);
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                node.affiliationsMerge();
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations)");
                this.nodesToSave.add(node);
                this.tlazyWriteThread.wakeup();
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ++this.updateSubscriptionsCalled;
        if (nodeSubscriptions instanceof tigase.pubsub.repository.cached.NodeSubscriptions) {
            Node node = this.getNode(nodeName);
            if (node != null) {
                if (node.getNodeSubscriptions() != nodeSubscriptions) {
                    throw new RuntimeException("INCORRECT");
                }
                node.subscriptionsMerge();
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
                this.nodesToSave.add(node);
                this.tlazyWriteThread.wakeup();
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    private class SizedCache
    extends LinkedHashMap<String, Node> {
        private static final long serialVersionUID = 1L;
        private int maxCacheSize;

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = 1000;
            this.maxCacheSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > this.maxCacheSize && !eldest.getValue().needsWriting();
        }
    }

    private class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getCreationTime() < o2.getCreationTime()) {
                return -1;
            }
            if (o1.getCreationTime() > o2.getCreationTime()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class LazyWriteThread
    implements Runnable {
        private boolean stop = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CachedPubSubRepository.this.log.info("Started new LazyWriteThread.");
            while (!this.stop || CachedPubSubRepository.this.nodesToSave.size() > 0) {
                Node node = (Node)CachedPubSubRepository.this.nodesToSave.pollFirst();
                if (node != null) {
                    long start = System.currentTimeMillis();
                    ++CachedPubSubRepository.this.repo_writes;
                    Node node2 = node;
                    synchronized (node2) {
                        try {
                            if (node.isDeleted()) {
                                continue;
                            }
                            if (node.affiliationsNeedsWriting()) {
                                CachedPubSubRepository.this.dao.updateAffiliations(node.getName(), node.getNodeAffiliations().serialize());
                                node.affiliationsSaved();
                            }
                            if (node.subscriptionsNeedsWriting()) {
                                FragmentedMap<String, UsersSubscription> fm = node.getNodeSubscriptions().getFragmentedMap();
                                fm.defragment();
                                for (Integer deletedIndex : fm.getRemovedFragmentIndexes()) {
                                    CachedPubSubRepository.this.dao.removeSubscriptions(node.getName(), deletedIndex);
                                }
                                for (Integer changedIndex : fm.getChangedFragmentIndexes()) {
                                    Map<String, UsersSubscription> ft = fm.getFragment(changedIndex);
                                    CachedPubSubRepository.this.dao.updateSubscriptions(node.getName(), changedIndex, node.getNodeSubscriptions().serialize(ft));
                                }
                                fm.cleanChangingLog();
                                node.subscriptionsSaved();
                            }
                            if (node.configNeedsWriting()) {
                                CachedPubSubRepository.this.dao.updateNodeConfig(node.getName(), node.getNodeConfig().getFormElement().toString());
                                node.configSaved();
                            }
                        }
                        catch (Exception e) {
                            CachedPubSubRepository.this.log.log(Level.WARNING, "Problem saving pubsub data: ", e);
                        }
                        if (node.needsWriting()) {
                            CachedPubSubRepository.this.nodesToSave.add(node);
                        }
                    }
                    long end = System.currentTimeMillis();
                    CachedPubSubRepository.this.writingTime += end - start;
                    continue;
                }
                if (this.stop) continue;
                try {
                    ConcurrentSkipListSet start = CachedPubSubRepository.this.nodesToSave;
                    synchronized (start) {
                        CachedPubSubRepository.this.nodesToSave.wait();
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            CachedPubSubRepository.this.log.info("Stopped LazyWriteThread...");
        }

        public void stop() {
            CachedPubSubRepository.this.log.info("Stopping LazyWriteThread...");
            this.stop = true;
            this.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            ConcurrentSkipListSet concurrentSkipListSet = CachedPubSubRepository.this.nodesToSave;
            synchronized (concurrentSkipListSet) {
                CachedPubSubRepository.this.nodesToSave.notify();
            }
        }
    }
}

