/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class SubscribeNodeModule
extends AbstractModule {
    private static final Criteria CRIT_SUBSCRIBE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"subscribe"));
    private final PendingSubscriptionModule pendingSubscriptionModule;

    public SubscribeNodeModule(PubSubConfig config, IPubSubRepository pubsubRepository, PendingSubscriptionModule manageSubscriptionModule) {
        super(config, pubsubRepository);
        this.pendingSubscriptionModule = manageSubscriptionModule;
    }

    private static Affiliation calculateNewOwnerAffiliation(Affiliation ownerAffiliation, Affiliation newAffiliation) {
        if (ownerAffiliation.getWeight() > newAffiliation.getWeight()) {
            return ownerAffiliation;
        }
        return newAffiliation;
    }

    public static Element makeSubscription(String nodeName, String subscriberJid, Subscription newSubscription, String subid) {
        Element resPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        Element resSubscription = new Element("subscription");
        resPubSub.addChild((XMLNodeIfc)resSubscription);
        resSubscription.setAttribute("node", nodeName);
        resSubscription.setAttribute("jid", subscriberJid);
        resSubscription.setAttribute("subscription", newSubscription.name());
        if (subid != null) {
            resSubscription.setAttribute("subid", subid);
        }
        return resPubSub;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions", "http://jabber.org/protocol/pubsub#auto-subscribe", "http://jabber.org/protocol/pubsub#subscribe", "http://jabber.org/protocol/pubsub#subscription-notifications"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_SUBSCRIBE;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element pubSub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element subscribe = pubSub.getChild("subscribe");
        String senderJid = packet.getAttributeStaticStr("from");
        String nodeName = subscribe.getAttributeStaticStr("node");
        String jid = subscribe.getAttributeStaticStr("jid");
        try {
            boolean allowed;
            Subscription newSubscription;
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(packet.getElement(), Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid, nodeConfig.getDomains())) {
                throw new PubSubException(Authorization.FORBIDDEN, "User blocked by domain");
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid);
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && senderAffiliation.getAffiliation() != Affiliation.owner && !JIDUtils.getNodeID((String)jid).equals(JIDUtils.getNodeID((String)senderJid))) {
                throw new PubSubException(packet.getElement(), Authorization.BAD_REQUEST, PubSubErrorCondition.INVALID_JID);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, nodeName);
            Subscription subscription = nodeSubscriptions.getSubscription(jid);
            if (senderAffiliation != null && !senderAffiliation.getAffiliation().isSubscribe()) {
                throw new PubSubException(Authorization.FORBIDDEN, "Not enough privileges to subscribe");
            }
            AccessModel accessModel = nodeConfig.getNodeAccessModel();
            if (subscription != null && subscription == Subscription.pending && !this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && senderAffiliation.getAffiliation() != Affiliation.owner) {
                throw new PubSubException(Authorization.FORBIDDEN, PubSubErrorCondition.PENDING_SUBSCRIPTION, "Subscription is pending");
            }
            if (accessModel == AccessModel.whitelist && (senderAffiliation == null || senderAffiliation.getAffiliation() == Affiliation.none || senderAffiliation.getAffiliation() == Affiliation.outcast)) {
                throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
            }
            ArrayList<Packet> results = new ArrayList<Packet>();
            Affiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid).getAffiliation();
            if (this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) || senderAffiliation.getAffiliation() == Affiliation.owner) {
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else if (accessModel == AccessModel.open) {
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else if (accessModel == AccessModel.authorize) {
                newSubscription = Subscription.pending;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.none);
            } else if (accessModel == AccessModel.presence) {
                allowed = this.hasSenderSubscription(jid, nodeAffiliations, nodeSubscriptions);
                if (!allowed) {
                    throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
                }
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else if (accessModel == AccessModel.roster) {
                allowed = this.isSenderInRosterGroup(jid, nodeConfig, nodeAffiliations, nodeSubscriptions);
                if (!allowed) {
                    throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
                }
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else if (accessModel == AccessModel.whitelist) {
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, "AccessModel '" + accessModel.name() + "' is not implemented yet");
            }
            String subid = nodeSubscriptions.getSubscriptionId(jid);
            if (subid == null) {
                subid = nodeSubscriptions.addSubscriberJid(jid, newSubscription);
                nodeAffiliations.addAffiliation(jid, affiliation);
                if (accessModel == AccessModel.authorize && !this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && senderAffiliation.getAffiliation() != Affiliation.owner) {
                    results.addAll(this.pendingSubscriptionModule.sendAuthorizationRequest(nodeName, packet.getStanzaTo(), subid, jid, nodeAffiliations));
                }
            } else {
                nodeSubscriptions.changeSubscription(jid, newSubscription);
                nodeAffiliations.changeAffiliation(jid, affiliation);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(toJid, nodeName, nodeSubscriptions);
            }
            if (nodeAffiliations.isChanged()) {
                this.repository.update(toJid, nodeName, nodeAffiliations);
            }
            Packet result = packet.okResult(SubscribeNodeModule.makeSubscription(nodeName, jid, newSubscription, subid), 0);
            results.add(result);
            return results;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

