/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ManageSubscriptionModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    public ManageSubscriptionModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    private static Packet createSubscriptionNotification(JID fromJid, JID toJid, String nodeName, Subscription subscription) {
        Packet message = Message.getMessage((JID)fromJid, (JID)toJid, null, null, null, null, null);
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.getElement().addChild((XMLNodeIfc)pubsub);
        Element affilations = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild((XMLNodeIfc)affilations);
        affilations.addChild((XMLNodeIfc)new Element("subscription", new String[]{"jid", "subscription"}, new String[]{toJid.toString(), subscription.name()}));
        return message;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            if (type == null || type != StanzaType.get && type != StanzaType.set) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(Authorization.ITEM_NOT_FOUND);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, nodeName);
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, nodeName);
            String senderJid = element.getAttributeStaticStr("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            if (type == StanzaType.get) {
                this.processGet(packet, subscriptions, nodeName, nodeSubscriptions, packetWriter);
            } else if (type == StanzaType.set) {
                this.processSet(packet, subscriptions, nodeName, nodeConfig, nodeSubscriptions, packetWriter);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(toJid, nodeName, nodeSubscriptions);
            }
            return null;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void processGet(Packet packet, Element subscriptions, String nodeName, ISubscriptions nodeSubscriptions, PacketWriter packetWriter) throws RepositoryException {
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        Packet iq = packet.okResult(ps, 0);
        Element afr = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        ps.addChild((XMLNodeIfc)afr);
        UsersSubscription[] subscribers = nodeSubscriptions.getSubscriptions();
        if (subscribers != null) {
            for (UsersSubscription usersSubscription : subscribers) {
                if (usersSubscription.getSubscription() == Subscription.none) continue;
                Element subscription = new Element("subscription", new String[]{"jid", "subscription"}, new String[]{usersSubscription.getJid().toString(), usersSubscription.getSubscription().name()});
                afr.addChild((XMLNodeIfc)subscription);
            }
        }
        packetWriter.write(iq);
    }

    private void processSet(Packet packet, Element subscriptions, String nodeName, AbstractNodeConfig nodeConfig, ISubscriptions nodeSubscriptions, PacketWriter packetWriter) throws PubSubException, RepositoryException {
        List subss = subscriptions.getChildren();
        for (Element a : subss) {
            if ("subscription".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        for (Element af : subss) {
            String strSubscription = af.getAttributeStaticStr("subscription");
            String jidStr = af.getAttributeStaticStr("jid");
            JID jid = JID.jidInstanceNS((String)jidStr);
            if (strSubscription == null) continue;
            Subscription newSubscription = Subscription.valueOf(strSubscription);
            Subscription oldSubscription = nodeSubscriptions.getSubscription(jidStr);
            Subscription subscription = oldSubscription = oldSubscription == null ? Subscription.none : oldSubscription;
            if (oldSubscription == Subscription.none && newSubscription != Subscription.none) {
                nodeSubscriptions.addSubscriberJid(jidStr, newSubscription);
                if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
                packetWriter.write(ManageSubscriptionModule.createSubscriptionNotification(packet.getStanzaTo(), jid, nodeName, newSubscription));
                continue;
            }
            nodeSubscriptions.changeSubscription(jidStr, newSubscription);
            if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
            packetWriter.write(ManageSubscriptionModule.createSubscriptionNotification(packet.getStanzaTo(), jid, nodeName, newSubscription));
        }
        Packet iq = packet.okResult((Element)null, 0);
        packetWriter.write(iq);
    }
}

