/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Module;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class DiscoverInfoModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"));
    private ArrayList<Module> modules;

    public DiscoverInfoModule(PubSubConfig config, IPubSubRepository pubsubRepository, ArrayList<Module> modules) {
        super(config, pubsubRepository);
        this.modules = modules;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        try {
            Element element = packet.getElement();
            String senderJid = element.getAttributeStaticStr("from");
            Element query = element.getChild("query", "http://jabber.org/protocol/disco#info");
            String nodeName = query.getAttributeStaticStr("node");
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            if (nodeName == null) {
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type", "name"}, new String[]{"pubsub", "service", "Publish-Subscribe"}));
                for (Module module : this.modules) {
                    String[] features = module.getFeatures();
                    if (features == null) continue;
                    for (String f : features) {
                        resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{f}));
                    }
                }
            } else {
                boolean allowed;
                AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(packet.getStanzaTo().getBareJID(), nodeName);
                if (nodeConfig == null) {
                    throw new PubSubException(Authorization.ITEM_NOT_FOUND);
                }
                boolean bl = allowed = senderJid == null || nodeConfig == null ? true : Utils.isAllowedDomain(senderJid, nodeConfig.getDomains());
                if (!allowed) {
                    throw new PubSubException(Authorization.FORBIDDEN);
                }
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfig.getNodeType().name()}));
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
                Form form = new Form("result", null, null);
                form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#meta-data"));
                form.addField(Field.fieldTextSingle((String)"pubsub#title", (String)nodeConfig.getTitle(), (String)"A short name for the node"));
                resultQuery.addChild((XMLNodeIfc)form.getElement());
            }
            return DiscoverInfoModule.makeArray(resultIq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

