/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocCommandManager;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;

public class AdHocConfigCommandModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"command", (String)"http://jabber.org/protocol/commands"));
    private final AdHocCommandManager commandsManager = new AdHocCommandManager();

    public AdHocConfigCommandModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    public List<Element> getCommandListItems(String senderJid, String toJid) {
        ArrayList<Element> commandsList = new ArrayList<Element>();
        for (AdHocCommand command : this.commandsManager.getAllCommands()) {
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)senderJid))) continue;
            commandsList.add(new Element("item", new String[]{"jid", "node", "name"}, new String[]{toJid, command.getNode(), command.getName()}));
        }
        return commandsList;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/commands"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        try {
            List<Packet> result = AdHocConfigCommandModule.makeArray(this.commandsManager.process(packet));
            return result;
        }
        catch (AdHocCommandException e) {
            throw new PubSubException(e.getErrorCondition(), e.getMessage());
        }
    }

    public void register(AdHocCommand command) {
        this.commandsManager.registerCommand(command);
    }
}

