/*
 * Decompiled with CFR 0.152.
 */
package tigase.adhoc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdHocSession;
import tigase.adhoc.AdhHocRequest;
import tigase.server.Packet;
import tigase.util.SimpleCache;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class AdHocCommandManager {
    private final Map<String, AdHocCommand> commands = new HashMap<String, AdHocCommand>();
    private final SimpleCache<String, AdHocSession> sessions = new SimpleCache(100, 10000L);

    public Collection<AdHocCommand> getAllCommands() {
        return this.commands.values();
    }

    public Packet process(Packet packet) throws AdHocCommandException {
        Element element = packet.getElement();
        String senderJid = element.getAttributeStaticStr("from");
        Element command = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command.getAttributeStaticStr("node");
        String action = command.getAttributeStaticStr("action");
        String sessionId = command.getAttributeStaticStr("sessionid");
        AdHocCommand adHocCommand = this.commands.get(node);
        if (adHocCommand != null) {
            AdHocResponse.State currentState = null;
            AdhHocRequest request = new AdhHocRequest(packet, command, node, senderJid, action, sessionId);
            AdHocResponse response = new AdHocResponse(sessionId, currentState);
            AdHocSession session = sessionId == null ? new AdHocSession() : (AdHocSession)this.sessions.get((Object)sessionId);
            adHocCommand.execute(request, response);
            Element commandResult = new Element("command", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/commands", node});
            commandResult.addAttribute("status", response.getNewState().name());
            if (response.getCurrentState() == null && response.getNewState() == AdHocResponse.State.executing) {
                this.sessions.put((Object)response.getSessionid(), (Object)session);
            } else if (response.getSessionid() != null && (response.getNewState() == AdHocResponse.State.canceled || response.getNewState() == AdHocResponse.State.completed)) {
                this.sessions.remove((Object)response.getSessionid());
            }
            if (response.getSessionid() != null) {
                commandResult.addAttribute("sessionid", response.getSessionid());
            }
            for (Element r : response.getElements()) {
                commandResult.addChild((XMLNodeIfc)r);
            }
            return packet.okResult(commandResult, 0);
        }
        return null;
    }

    public void registerCommand(AdHocCommand command) {
        this.commands.put(command.getNode(), command);
    }
}

