/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector.provider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.StatisticsData;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class StatisticsUploader {
    private static final Logger log = Logger.getLogger(StatisticsUploader.class.getCanonicalName());
    private static final Timer timer = new Timer();
    private static final int MAX_COUNT = 30;
    private static final String CONSUMER_HOST = "stats.tigase.org";
    private static final String CONSUMER_PATH = "/rest/stats/upload";
    private static final int CONSUMER_PORT = 8080;
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private final ElementSigner signer;

    public StatisticsUploader(ElementSigner signer) {
        this.signer = signer;
    }

    public void upload(StatisticsData data, ResultCallback callback) {
        Element statsElem = data.toElement();
        Element msg = this.signer.sign(statsElem);
        String msgStr = msg.toString();
        this.queueUpload(msgStr, callback, 0);
    }

    private void queueUpload(final String data, final ResultCallback callback, final int count) {
        log.log(Level.FINEST, "queuing data for upload = {0} try no = {1}", new Object[]{data, count});
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    boolean done = false;
                    Element result = null;
                    Exception exception = null;
                    try {
                        result = StatisticsUploader.this.uploadData(data);
                        result = StatisticsUploader.this.signer.verify(result);
                        done = "result".equals(result.getAttribute("type"));
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "exception uploading statistics", ex);
                        exception = ex;
                    }
                    if (!done) {
                        if (count >= 30) {
                            log.log(Level.WARNING, "could not upload statistics data, permanent upload failure");
                            callback.onFailure(exception);
                        } else {
                            log.log(Level.FINE, "could not upload statistics data, queuing for retry, attempt " + count + " out of " + 30);
                            StatisticsUploader.this.queueUpload(data, callback, count + 1);
                        }
                    } else {
                        log.log(Level.FINER, "statistics data successfully uploaded");
                        callback.onSuccess(result);
                    }
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "exception during processing upload request, should not happen", ex);
                }
            }
        }, TimeUnit.MINUTES.toMillis(count * 2));
    }

    private Element uploadData(String data) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(CONSUMER_HOST, 8080);
        Socket socket = new Socket();
        socket.connect(addr, 60000);
        byte[] byteData = data.getBytes();
        socket.getOutputStream().write(this.getHttpHeaders("POST", byteData.length));
        socket.getOutputStream().write(byteData);
        char[] cbuf = new char[2048];
        int read = 0;
        DomBuilderHandler handler = new DomBuilderHandler();
        InputStreamReader reader = new InputStreamReader(socket.getInputStream(), "UTF-8");
        while ((read = reader.read(cbuf)) >= 0) {
            parser.parse((SimpleHandler)handler, cbuf, 0, read);
        }
        Queue results = handler.getParsedElements();
        if (results.isEmpty()) {
            throw new IOException("No response");
        }
        Element result = (Element)results.poll();
        return result;
    }

    private byte[] getHttpHeaders(String action, int length) {
        return (action + " " + CONSUMER_PATH + " HTTP/1.1\r\n" + "Host: " + CONSUMER_HOST + "\r\n" + "Content-Type: application/xml\r\n" + "Content-Length: " + length + "\r\n" + "Connection: close\r\n\r\n").getBytes();
    }

    public static interface ResultCallback {
        public void onSuccess(Element var1);

        public void onFailure(Exception var1);
    }
}

