/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;

public class StatisticsData {
    private static final String a = "statistics";
    private static final String b = "timestamp";
    private static final String c = "domain";
    private static final String d = "vhosts";
    private static final String e = "uptime";
    private static final String f = "heap";
    private static final String g = "item";
    private static final String h = "max";
    private static final String i = "used";
    private static final String j = "users";
    private static final String k = "online";
    private static final String l = "active";
    private static final String m = "cluster";
    private static final String n = "nodes_count";
    public static final String[] DOMAIN_PATH = new String[]{"statistics", "domain"};
    public static final String[] TIMESTAMP_PATH = new String[]{"statistics", "timestamp"};
    public static final String[] VHOSTS_ITEM_PATH = new String[]{"statistics", "vhosts", "item"};
    public static final String[] UPTIME_PATH = new String[]{"statistics", "uptime"};
    public static final String[] HEAP_USED_PATH = new String[]{"statistics", "heap", "used"};
    public static final String[] HEAP_MAX_PATH = new String[]{"statistics", "heap", "max"};
    public static final String[] CLUSTER_NODES_COUNT_PATH = new String[]{"statistics", "cluster", "nodes_count"};
    public static final String[] USERS_ONLINE_PATH = new String[]{"statistics", "users", "online"};
    public static final String[] USERS_ACTIVE_PATH = new String[]{"statistics", "users", "active"};
    private static final SimpleDateFormat o = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected static int VERSION = 1;
    private final BareJID p;
    private final Date q;
    private List r;
    private long s;
    private long t;
    private long u;
    private long v;
    private long w;
    private int x;

    public StatisticsData(BareJID bareJID) {
        this(bareJID, new Date());
    }

    private StatisticsData(BareJID bareJID, Date date) {
        this.p = bareJID;
        this.q = date;
        this.r = new ArrayList();
    }

    public int getVersion() {
        return VERSION;
    }

    public BareJID getDomain() {
        return this.p;
    }

    public Date getTimestamp() {
        return this.q;
    }

    public List getVHosts() {
        return Collections.unmodifiableList(this.r);
    }

    public void addVHost(BareJID bareJID) {
        this.r.add(bareJID);
    }

    public void addVHosts(Collection collection) {
        this.r.addAll(collection);
    }

    public long getUptime() {
        return this.s;
    }

    public void setUptime(long l) {
        this.s = l;
    }

    public long getHeapUsed() {
        return this.u;
    }

    public void setHeapUsed(long l) {
        this.u = l;
    }

    public long getHeapMax() {
        return this.t;
    }

    public void setHeapMax(long l) {
        this.t = l;
    }

    public int getClusterNodesCount() {
        return this.x;
    }

    public void setClusterNodesCount(int n) {
        this.x = n;
    }

    public long getUsersActive() {
        return this.w;
    }

    public void setUsersActive(long l) {
        this.w = l;
    }

    public long getUsersOnline() {
        return this.v;
    }

    public void setUsersOnline(long l) {
        this.v = l;
    }

    public static StatisticsData fromElement(Element element) throws TigaseStringprepException {
        if (element.getName() != a) {
            throw new IllegalArgumentException("Invalid element passed, elem = " + element.toString());
        }
        int n = Integer.parseInt(element.getAttributeStaticStr("version"));
        if (n != VERSION) {
            throw new IllegalArgumentException("Invalid version, expected " + VERSION + " got " + n);
        }
        Object object = null;
        Object object2 = element.getChildCData(DOMAIN_PATH);
        if (object2 != null) {
            object = BareJID.bareJIDInstance((String)object2);
        }
        object2 = null;
        String string = element.getChildCData(TIMESTAMP_PATH);
        Object object3 = o;
        synchronized (object3) {
            try {
                object2 = o.parse(string);
            }
            catch (ParseException parseException) {}
        }
        object3 = new StatisticsData((BareJID)object, (Date)object2);
        object = element.getChildren(VHOSTS_ITEM_PATH);
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Element)object.next();
            ((StatisticsData)object3).r.add(BareJID.bareJIDInstance((String)object2.getCData()));
        }
        ((StatisticsData)object3).s = Long.parseLong(element.getCData(UPTIME_PATH));
        ((StatisticsData)object3).u = Long.parseLong(element.getCData(HEAP_USED_PATH));
        ((StatisticsData)object3).t = Long.parseLong(element.getCData(HEAP_MAX_PATH));
        ((StatisticsData)object3).x = Integer.parseInt(element.getCData(CLUSTER_NODES_COUNT_PATH));
        ((StatisticsData)object3).v = Long.parseLong(element.getCData(USERS_ONLINE_PATH));
        ((StatisticsData)object3).w = Long.parseLong(element.getCData(USERS_ACTIVE_PATH));
        return object3;
    }

    public Element toElement() {
        BareJID bareJID2;
        Object object;
        Element element = new Element(a);
        element.setAttribute("version", String.valueOf(this.getVersion()));
        element.addChild((XMLNodeIfc)new Element(c, this.p.toString()));
        SimpleDateFormat simpleDateFormat = o;
        synchronized (simpleDateFormat) {
            object = o.format(this.q);
        }
        element.addChild((XMLNodeIfc)new Element(b, (String)object));
        if (!this.r.isEmpty()) {
            simpleDateFormat = new Element(d);
            for (BareJID bareJID2 : this.r) {
                simpleDateFormat.addChild((XMLNodeIfc)new Element(g, bareJID2.toString()));
            }
            element.addChild((XMLNodeIfc)simpleDateFormat);
        }
        element.addChild((XMLNodeIfc)new Element(e, String.valueOf(this.s)));
        simpleDateFormat = new Element(f);
        simpleDateFormat.addChild((XMLNodeIfc)new Element(i, String.valueOf(this.u)));
        simpleDateFormat.addChild((XMLNodeIfc)new Element(h, String.valueOf(this.t)));
        element.addChild((XMLNodeIfc)simpleDateFormat);
        object = new Element(m);
        object.addChild((XMLNodeIfc)new Element(n, String.valueOf(this.x)));
        element.addChild((XMLNodeIfc)object);
        bareJID2 = new Element(j);
        bareJID2.addChild((XMLNodeIfc)new Element(k, String.valueOf(this.v)));
        bareJID2.addChild((XMLNodeIfc)new Element(l, String.valueOf(this.w)));
        element.addChild((XMLNodeIfc)bareJID2);
        return element;
    }
}

