/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.server.Message;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;

public class MessageArchiveDB {
    private static final String JIDS_ID = "jid_id";
    private static final String JIDS_JID = "jid";
    private static final String JIDS_TABLE = "tig_ma_jids";
    private static final Logger log = Logger.getLogger(MessageArchiveDB.class.getCanonicalName());
    private static final long LONG_NULL = 0L;
    private static final long MILIS_PER_DAY = 86400000L;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String MSGS_BUDDY_ID = "buddy_id";
    private static final String MSGS_DIRECTION = "direction";
    private static final String MSGS_MSG = "msg";
    private static final String MSGS_OWNER_ID = "owner_id";
    private static final String MSGS_TABLE = "tig_ma_msgs";
    private static final String MSGS_TIMESTAMP = "ts";
    private static final String MSGS_TYPE = "type";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final String GET_JID_IDS_QUERY = "select jid, jid_id from tig_ma_jids where jid = ? or jid = ?";
    private static final String GET_JID_ID_QUERY = "select jid, jid_id from tig_ma_jids where jid = ?";
    private static final String ADD_JID_QUERY = "insert into tig_ma_jids (jid) values (?)";
    private static final String DERBY_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint generated by default as identity not null, jid varchar(2049), primary key ( jid_id ));create unique index tig_ma_jids_jid on tig_ma_jids (jid);";
    private static final String PGSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigserial, jid varchar(2049), primary key (jid_id)); create unique index tig_ma_jids_jid on tig_ma_jids ( jid);";
    private static final String MYSQL_CREATE_JIDS = "create table tig_ma_jids ( jid_id bigint unsigned NOT NULL auto_increment, jid varchar(2049), primary key (jid_id)); ";
    private static final String GET_MESSAGES = "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and date(ts) = date(?) order by ts limit ? offset ?";
    private static final String DERBY_GET_MESSAGES = "select msg from tig_ma_msgs where owner_id = ? and buddy_id = ? and date(ts) = ? order by ts offset ? rows fetch next ? rows only";
    private static final String GET_COLLECTIONS = "select distinct date(ts) from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts <= ? and ts >= ? order by date(ts)";
    private static final String ADD_MESSAGE = "insert into tig_ma_msgs (owner_id, buddy_id, ts, direction, type, msg) values (?, ?, ?, ?, ?, ?)";
    private static final String REMOVE_MSGS = "delete from tig_ma_msgs where owner_id = ? and buddy_id = ? and ts <= ? and ts >= ?";
    private static final String DERBY_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint references tig_ma_jids(jid_id),buddy_id bigint references tig_ma_jids(jid_id),ts timestamp, direction smallint, type varchar(10), msg varchar(32672));create index tig_ma_msgs_owner_id_index on tig_ma_msgs (owner_id);create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs (owner_id, buddy_id);create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs (owner_id, ts, buddy_id);";
    private static final String PGSQL_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint, buddy_id bigint, ts timestamp, direction smallint, type varchar(10),msg text, foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id) ); create index tig_ma_msgs_owner_id_index on tig_ma_msgs ( owner_id); create index tig_ma_msgs_owner_id_buddy_id_index on tig_ma_msgs ( owner_id, buddy_id); create index tig_ma_msgs_owner_id_ts_buddy_id_index on tig_ma_msgs ( owner_id, ts, buddy_id); ";
    private static final String MYSQL_CREATE_MSGS = "create table tig_ma_msgs (owner_id bigint unsigned, buddy_id bigint unsigned, ts timestamp, direction smallint, type varchar(10),msg text, foreign key (buddy_id) references tig_ma_jids (jid_id), foreign key (owner_id) references tig_ma_jids (jid_id), key (owner_id), key (owner_id, buddy_id), key (owner_id, ts, buddy_id));";
    private DataRepository data_repo = null;
    private boolean derby = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        SimpleDateFormat simpleDateFormat = formatter;
        synchronized (simpleDateFormat) {
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)conn_str, params);
            if (conn_str.startsWith("jdbc:mysql:")) {
                this.data_repo.checkTable(JIDS_TABLE, MYSQL_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, MYSQL_CREATE_MSGS);
            } else if (conn_str.contains("derby")) {
                this.derby = true;
                this.data_repo.checkTable(JIDS_TABLE, DERBY_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, DERBY_CREATE_MSGS);
            } else {
                this.data_repo.checkTable(JIDS_TABLE, PGSQL_CREATE_JIDS);
                this.data_repo.checkTable(MSGS_TABLE, PGSQL_CREATE_MSGS);
            }
            this.data_repo.initPreparedStatement(ADD_JID_QUERY, ADD_JID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_ID_QUERY, GET_JID_ID_QUERY);
            this.data_repo.initPreparedStatement(GET_JID_IDS_QUERY, GET_JID_IDS_QUERY);
            this.data_repo.initPreparedStatement(ADD_MESSAGE, ADD_MESSAGE);
            this.data_repo.initPreparedStatement(GET_COLLECTIONS, GET_COLLECTIONS);
            if (this.derby) {
                this.data_repo.initPreparedStatement(GET_MESSAGES, DERBY_GET_MESSAGES);
            } else {
                this.data_repo.initPreparedStatement(GET_MESSAGES, GET_MESSAGES);
            }
            this.data_repo.initPreparedStatement(REMOVE_MSGS, REMOVE_MSGS);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "MessageArchiveDB initialization exception", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveMessage(BareJID owner, BareJID buddy, short direction, Element msg) {
        try {
            PreparedStatement add_message_st;
            String owner_str = owner.toString();
            String buddy_str = buddy.toString();
            long[] jids_ids = this.getJidsIds(owner_str, buddy_str);
            long owner_id = jids_ids[0] != 0L ? jids_ids[0] : this.addJidId(owner_str);
            long buddy_id = jids_ids[1] != 0L ? jids_ids[1] : this.addJidId(buddy_str);
            Timestamp mtime = null;
            Element delay = msg.findChildStaticStr(Message.MESSAGE_DELAY_PATH);
            if (delay != null) {
                try {
                    String stamp = delay.getAttributeStaticStr("stamp");
                    mtime = this.parseTimestamp(stamp);
                }
                catch (ParseException e1) {}
            } else {
                mtime = new Timestamp(System.currentTimeMillis());
            }
            msg.addAttribute("time", String.valueOf(mtime.getTime()));
            String type = msg.getAttributeStaticStr(MSGS_TYPE);
            String msgStr = msg.toString();
            PreparedStatement preparedStatement = add_message_st = this.data_repo.getPreparedStatement(owner, ADD_MESSAGE);
            synchronized (preparedStatement) {
                add_message_st.setLong(1, owner_id);
                add_message_st.setLong(2, buddy_id);
                add_message_st.setTimestamp(3, mtime);
                add_message_st.setShort(4, direction);
                add_message_st.setString(5, type);
                add_message_st.setString(6, msgStr);
                add_message_st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: {0}", msg);
        }
    }

    public List<Element> getCollections(BareJID owner, String withJid, java.util.Date start, java.util.Date end, boolean before, int limit) throws SQLException {
        if (start == null) {
            start = new java.util.Date(0L);
        }
        if (end == null) {
            end = new java.util.Date(0L);
        }
        LinkedList<Element> results = new LinkedList<Element>();
        List<String> ids = this.getCollectionsPriv(owner, withJid, start, end, before, limit);
        for (String id : ids) {
            results.add(new Element("chat", new String[]{"with", "start"}, new String[]{withJid, id}));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getItems(BareJID owner, String withJid, java.util.Date start, int limit, int offset) throws SQLException {
        long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
        ResultSet rs = null;
        StringBuilder buf = new StringBuilder(16384);
        Timestamp collection = new Timestamp(start.getTime());
        try {
            PreparedStatement get_messages_st;
            PreparedStatement preparedStatement = get_messages_st = this.data_repo.getPreparedStatement(owner, GET_MESSAGES);
            synchronized (preparedStatement) {
                get_messages_st.setLong(1, jids_ids[0]);
                get_messages_st.setLong(2, jids_ids[1]);
                if (this.derby) {
                    get_messages_st.setTimestamp(3, collection);
                    get_messages_st.setInt(4, offset);
                    get_messages_st.setInt(5, limit);
                } else {
                    long milis = collection.getTime() / 86400000L;
                    get_messages_st.setDate(3, new Date(milis * 24L * 60L * 60L * 1000L));
                    get_messages_st.setInt(4, limit);
                    get_messages_st.setInt(5, offset);
                }
                rs = get_messages_st.executeQuery();
                while (rs.next()) {
                    buf.append(rs.getString(1));
                }
            }
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        LinkedList<Element> msgs = null;
        if (buf != null) {
            String results = buf.toString();
            msgs = new LinkedList<Element>();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, results.toCharArray(), 0, results.length());
            Queue queue = domHandler.getParsedElements();
            String ownerStr = owner.toString();
            Element msg = null;
            while ((msg = (Element)queue.poll()) != null) {
                Element item = new Element(msg.getAttributeStaticStr("from").startsWith(ownerStr) ? "to" : "from");
                item.addChild((XMLNodeIfc)msg.getChild("body"));
                item.setAttribute("secs", String.valueOf((Long.valueOf(msg.getAttributeStaticStr("time")) - collection.getTime()) / 1000L));
                msgs.add(item);
            }
            Collections.sort(msgs, new Comparator<Element>(){

                @Override
                public int compare(Element m1, Element m2) {
                    return m1.getAttributeStaticStr("secs").compareTo(m2.getAttributeStaticStr("secs"));
                }
            });
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItems(BareJID owner, String withJid, java.util.Date start, java.util.Date end) throws SQLException {
        PreparedStatement remove_msgs_st;
        long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
        if (start == null) {
            start = new java.util.Date(0L);
        }
        if (end == null) {
            end = new java.util.Date(0L);
        }
        Timestamp start_ = new Timestamp(start.getTime());
        Timestamp end_ = new Timestamp(end.getTime());
        PreparedStatement preparedStatement = remove_msgs_st = this.data_repo.getPreparedStatement(owner, REMOVE_MSGS);
        synchronized (preparedStatement) {
            PreparedStatement preparedStatement2 = remove_msgs_st;
            synchronized (preparedStatement2) {
                remove_msgs_st.setLong(1, jids_ids[0]);
                remove_msgs_st.setLong(2, jids_ids[1]);
                remove_msgs_st.setTimestamp(3, end_);
                remove_msgs_st.setTimestamp(4, start_);
                remove_msgs_st.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCollectionsPriv(BareJID owner, String withJid, java.util.Date start, java.util.Date end, boolean before, int limit) throws SQLException {
        Object object;
        long[] jids_ids = this.getJidsIds(owner.toString(), withJid);
        LinkedList<String> results = new LinkedList<String>();
        ResultSet rs = null;
        try {
            Timestamp start_ = new Timestamp(start.getTime());
            Timestamp end_ = new Timestamp(end.getTime());
            PreparedStatement get_collections_st = this.data_repo.getPreparedStatement(owner, GET_COLLECTIONS);
            object = get_collections_st;
            synchronized (object) {
                get_collections_st.setLong(1, jids_ids[0]);
                get_collections_st.setLong(2, jids_ids[1]);
                get_collections_st.setTimestamp(3, end_);
                get_collections_st.setTimestamp(4, start_);
                rs = get_collections_st.executeQuery();
                while (rs.next()) {
                    Timestamp day = rs.getTimestamp(1);
                    SimpleDateFormat simpleDateFormat = formatter2;
                    synchronized (simpleDateFormat) {
                        results.add(formatter2.format(day));
                    }
                }
            }
            object = results;
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected long[] getJidsIds(String ... jids) throws SQLException {
        long[] lArray;
        long[] results;
        ResultSet rs;
        block13: {
            PreparedStatement preparedStatement;
            block14: {
                PreparedStatement get_jid_id_st;
                rs = null;
                results = new long[jids.length];
                Arrays.fill(results, 0L);
                if (jids.length != 1) break block13;
                preparedStatement = get_jid_id_st = this.data_repo.getPreparedStatement(null, GET_JID_ID_QUERY);
                // MONITORENTER : preparedStatement
                get_jid_id_st.setString(1, jids[0]);
                rs = get_jid_id_st.executeQuery();
                if (!rs.next()) break block14;
                results[0] = rs.getLong(JIDS_ID);
                long[] lArray2 = results;
                // MONITOREXIT : preparedStatement
                this.data_repo.release(null, rs);
                return lArray2;
            }
            // MONITOREXIT : preparedStatement
            preparedStatement = null;
            this.data_repo.release(null, rs);
            return preparedStatement;
        }
        try {
            PreparedStatement get_jids_id_st;
            PreparedStatement preparedStatement = get_jids_id_st = this.data_repo.getPreparedStatement(null, GET_JID_IDS_QUERY);
            // MONITORENTER : preparedStatement
            for (int i = 0; i < jids.length; ++i) {
                get_jids_id_st.setString(i + 1, jids[i]);
            }
            rs = get_jids_id_st.executeQuery();
            int cnt = 0;
            while (rs.next()) {
                String db_jid = rs.getString(JIDS_JID);
                for (int i = 0; i < jids.length; ++i) {
                    if (!db_jid.equals(jids[i])) continue;
                    results[i] = rs.getLong(JIDS_ID);
                    ++cnt;
                }
            }
            lArray = results;
            // MONITOREXIT : preparedStatement
        }
        catch (Throwable throwable) {
            this.data_repo.release(null, rs);
            throw throwable;
        }
        this.data_repo.release(null, rs);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addJidId(String jid) throws SQLException {
        PreparedStatement add_jid_st;
        PreparedStatement preparedStatement = add_jid_st = this.data_repo.getPreparedStatement(null, ADD_JID_QUERY);
        synchronized (preparedStatement) {
            add_jid_st.setString(1, jid);
            add_jid_st.executeUpdate();
        }
        long[] jid_ids = this.getJidsIds(jid);
        if (jid_ids != null) {
            return jid_ids[0];
        }
        log.log(Level.WARNING, "I have just added new jid but it was not found.... {0}", jid);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp parseTimestamp(String tmp) throws ParseException {
        java.util.Date date = null;
        if (tmp.endsWith("Z")) {
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                date = formatter.parse(tmp);
            }
        }
        if (tmp.contains(".")) {
            SimpleDateFormat simpleDateFormat = formatter3;
            synchronized (simpleDateFormat) {
                date = formatter3.parse(tmp);
            }
        }
        SimpleDateFormat simpleDateFormat = formatter2;
        synchronized (simpleDateFormat) {
            date = formatter2.parse(tmp);
        }
        return new Timestamp(date.getTime());
    }
}

