/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Presence;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public class InvisibleCommand
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPreprocessorIfc {
    private static final String ID = "invisible-command";
    private static final Logger log = Logger.getLogger(InvisibleCommand.class.getCanonicalName());
    private static final String XMLNS = "urn:xmpp:invisible:0";
    private static final String[] VISIBLE_PATH = new String[]{"iq", "visible"};
    private static final String[] INVISIBLE_PATH = new String[]{"iq", "invisible"};
    private static final String[][] ELEMENT_PATHS = new String[][]{INVISIBLE_PATH, VISIBLE_PATH};
    private static final String[] XMLNSS = new String[]{"urn:xmpp:invisible:0", "urn:xmpp:invisible:0"};
    private static final String ACTIVE_KEY = "invisible-command-active";
    protected RosterAbstract roster_util = this.getRosterUtil();

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    protected RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        if (!session.isAuthorized()) {
            try {
                results.offer(session.getAuthState().getResponseMessage(packet, "Session is not yet authorized.", false));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.FINEST, "ignoring packet from not authorized session which is already of type error");
            }
            return;
        }
        try {
            try {
                StanzaType type = packet.getType();
                switch (type) {
                    case set: {
                        if (packet.getElement().findChildStaticStr(INVISIBLE_PATH) != null) {
                            session.putSessionData(ACTIVE_KEY, Boolean.TRUE);
                            Element presence = new Element("presence", new String[]{"from", "type"}, new String[]{session.getJID().toString(), "unavailable"});
                            session.putSessionData("user-presence", presence);
                            Presence.broadcastOffline(session, results, settings, this.roster_util);
                            session.removeSessionData("offline-bud-sent");
                        } else if (packet.getElement().findChildStaticStr(VISIBLE_PATH) != null) {
                            session.removeSessionData(ACTIVE_KEY);
                        }
                        results.offer(packet.okResult((Element)null, 0));
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "InvisibleCommand processing type is incorrect", false));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException ex) {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Not authorized", false));
            }
            catch (TigaseDBException ex) {
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Error accessing database", false));
            }
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.SEVERE, "packet error type exception", ex);
        }
    }

    @Override
    public boolean preProcess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (packet.getElemName() == "presence" && packet.getStanzaTo() == null && packet.getType() != StanzaType.unavailable) {
            Boolean active = (Boolean)session.getSessionData(ACTIVE_KEY);
            active = active != null && active != false;
            if (active.booleanValue()) {
                packet.processedBy(ID);
            }
            return active;
        }
        return false;
    }
}

