/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPResourceConnection;

public abstract class XMPPProcessor
implements XMPPImplIfc {
    protected static final String ALL_NAMES = "*";
    protected static final String[][] ALL_PATHS = new String[][]{{"*"}};
    private static final Logger log = Logger.getLogger(XMPPProcessor.class.getName());

    protected XMPPProcessor() {
    }

    @Override
    public Authorization canHandle(Packet packet, XMPPResourceConnection conn) {
        Authorization result = null;
        String[][] elemPaths = this.supElementNamePaths();
        if (elemPaths != null) {
            String[] elemXMLNS = this.supNamespaces();
            Set<StanzaType> types = this.supTypes();
            result = this.checkPacket(packet, elemPaths, elemXMLNS, types);
        } else if (this.walk(packet.getElement())) {
            result = Authorization.AUTHORIZED;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "XMPPProcessorIfc: {0} ({1})\n Request: {2}, conn: {3}, authorization: {4}", new Object[]{this.getClass().getSimpleName(), this.id(), packet, conn, result});
        }
        return result;
    }

    @Override
    public final int compareTo(XMPPImplIfc proc) {
        return this.getClass().getName().compareTo(proc.getClass().getName());
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    @Deprecated
    public int concurrentThreadsPerQueue() {
        return 1;
    }

    @Override
    public void init(Map<String, Object> settings) throws TigaseDBException {
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return null;
    }

    @Override
    public String[][] supElementNamePaths() {
        return null;
    }

    @Override
    @Deprecated
    public String[] supElements() {
        return null;
    }

    @Override
    public String[] supNamespaces() {
        return null;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return null;
    }

    @Override
    public Set<StanzaType> supTypes() {
        return null;
    }

    public XMPPProcessor getInstance() {
        return this;
    }

    @Override
    public void getStatistics(StatisticsList list) {
    }

    @Override
    @Deprecated
    public boolean isSupporting(String element, String ns) {
        String[] impl_elements = this.supElements();
        String[] impl_xmlns = this.supNamespaces();
        if (impl_elements != null && impl_xmlns != null) {
            for (int i = 0; i < impl_elements.length && i < impl_xmlns.length; ++i) {
                if (impl_elements[i] != element && impl_elements[i] != ALL_NAMES || impl_xmlns[i] != ns && impl_xmlns[i] != ALL_NAMES) continue;
                return true;
            }
        }
        return false;
    }

    private Authorization checkPacket(Packet packet, String[][] elemPaths, String[] elemXMLNS, Set<StanzaType> types) {
        boolean names_ok;
        Authorization result = null;
        boolean bl = names_ok = elemPaths == ALL_PATHS;
        if (!names_ok) {
            for (int i = 0; i < elemPaths.length; ++i) {
                if (!packet.isXMLNSStaticStr(elemPaths[i], elemXMLNS[i])) continue;
                names_ok = true;
                break;
            }
        }
        if (names_ok && (types == null || types.contains((Object)packet.getType()))) {
            result = Authorization.AUTHORIZED;
        }
        return result;
    }

    private boolean walk(Element elem) {
        List<Element> children;
        boolean result;
        String xmlns = elem.getXMLNS();
        if (xmlns == null) {
            xmlns = "jabber:client";
        }
        if (!(result = this.isSupporting(elem.getName(), xmlns)) && (children = elem.getChildren()) != null) {
            for (Element child : children) {
                result = this.walk(child);
            }
        }
        return result;
    }
}

