/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cert.CertCheckResult;
import tigase.net.ConnectionType;
import tigase.server.Packet;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.LocalhostException;
import tigase.server.xmppserver.NotLocalhostException;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.proc.S2SAbstractProcessor;
import tigase.util.Algorithms;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Dialback
extends S2SAbstractProcessor {
    private static final Logger log = Logger.getLogger(Dialback.class.getName());
    private static final Element features_required = new Element("dialback", new Element[]{new Element("required")}, new String[]{"xmlns"}, new String[]{"urn:xmpp:features:dialback"});
    private static final Element features = new Element("dialback", new String[]{"xmlns"}, new String[]{"urn:xmpp:features:dialback"});
    private static final String REQUESTED_RESULT_DOMAINS_KEY = "requested-result-domains-key";
    private long authenticationTimeOut = 30L;
    private boolean ejabberd_bug_workaround_active = false;

    public Dialback() {
        if (System.getProperty("s2s-ejabberd-bug-workaround-active") == null) {
            System.setProperty("s2s-ejabberd-bug-workaround-active", "true");
        }
        this.ejabberd_bug_workaround_active = Boolean.getBoolean("s2s-ejabberd-bug-workaround-active");
    }

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        boolean skipTLS;
        CID cid = (CID)serv.getSessionData().get("cid");
        boolean bl = skipTLS = cid == null ? false : this.skipTLSForHost(cid.getRemoteHost());
        if (p.getXMLNS() == "jabber:server:dialback") {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Processing dialback packet: {1}", new Object[]{serv, p});
            }
            this.processDialback(p, serv);
            return true;
        }
        if (p.isElement("features", "http://etherx.jabber.org/streams")) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Stream features received packet: {1}", new Object[]{serv, p});
            }
            CertCheckResult certCheckResult = (CertCheckResult)((Object)serv.getSessionData().get("cert-check-result"));
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, TLS Certificate check: {1}, packet: {2}", new Object[]{serv, certCheckResult, p});
            }
            if (p.isXMLNSStaticStr(FEATURES_STARTTLS_PATH, "urn:ietf:params:xml:ns:xmpp-tls") && certCheckResult == null && !skipTLS) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "{0}, Waiting for starttls, packet: {1}", new Object[]{serv, p});
                }
                return true;
            }
            if (certCheckResult == CertCheckResult.trusted && !p.isXMLNSStaticStr(FEATURES_DIALBACK_PATH, "urn:xmpp:features:dialback")) {
                if (this.ejabberd_bug_workaround_active) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, Ejabberd bug workaround active, proceeding to dialback anyway, packet: {1}", new Object[]{serv, p});
                    }
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "{0}, TLS trusted peer, no dialback needed or requested, packet: {1}", new Object[]{serv, p});
                    }
                    try {
                        CIDConnections cid_conns = this.handler.getCIDConnections(cid, true);
                        cid_conns.connectionAuthenticated(serv);
                    }
                    catch (NotLocalhostException ex) {
                        log.log(Level.INFO, "{0}, Incorrect local hostname, packet: {1}", new Object[]{serv, p});
                        serv.forceStop();
                    }
                    catch (LocalhostException ex) {
                        log.log(Level.INFO, "{0}, Incorrect remote hostname name, packet: {1}", new Object[]{serv, p});
                        serv.forceStop();
                    }
                    return true;
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "{0}, Initializing dialback, packet: {1}", new Object[]{serv, p});
            }
            this.initDialback(serv, serv.getSessionId());
        }
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
        this.handler.addTimerTask(new AuthenticationTimer(serv), this.authenticationTimeOut, TimeUnit.SECONDS);
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
        CertCheckResult certCheckResult = (CertCheckResult)((Object)serv.getSessionData().get("cert-check-result"));
        if (certCheckResult == CertCheckResult.trusted) {
            results.add(features);
        } else {
            results.add(features_required);
        }
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        if (attribs.containsKey("version")) {
            return null;
        }
        switch (serv.connectionType()) {
            case connect: {
                this.initDialback(serv, attribs.get("id"));
                break;
            }
        }
        return null;
    }

    private void initDialback(S2SIOService serv, String remote_id) {
        try {
            CID cid = (CID)serv.getSessionData().get("cid");
            CIDConnections cid_conns = this.handler.getCIDConnections(cid, false);
            String uuid = UUID.randomUUID().toString();
            String key = null;
            try {
                key = Algorithms.hexDigest(remote_id, uuid, "SHA");
            }
            catch (NoSuchAlgorithmException e) {
                key = uuid;
            }
            serv.setDBKey(key);
            cid_conns.addDBKey(remote_id, key);
            if (!serv.isHandshakingOnly()) {
                Element elem = new Element("db:result", key, new String[]{"xmlns:db"}, new String[]{"jabber:server:dialback"});
                this.addToResultRequested(serv, cid.getRemoteHost());
                serv.getS2SConnection().addControlPacket(Packet.packetInstance(elem, JID.jidInstanceNS(cid.getLocalHost()), JID.jidInstanceNS(cid.getRemoteHost())));
            }
            serv.getS2SConnection().sendAllControlPackets();
        }
        catch (NotLocalhostException ex) {
            this.generateStreamError(false, "host-unknown", serv);
        }
        catch (LocalhostException ex) {
            this.generateStreamError(false, "invalid-from", serv);
        }
    }

    private void processDialback(Packet p, S2SIOService serv) {
        CID cid_main = (CID)serv.getSessionData().get("cid");
        CID cid_packet = new CID(p.getStanzaTo().getDomain(), p.getStanzaFrom().getDomain());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, DIALBACK packet: {1}, CID_packet: {2}", new Object[]{serv, p, cid_packet});
        }
        CIDConnections cid_conns = null;
        if (cid_main == null) {
            cid_main = cid_packet;
            serv.getSessionData().put("cid", cid_main);
            serv.getSessionData().put("local-hostname", cid_main.getLocalHost());
            serv.getSessionData().put("remote-hostname", cid_main.getRemoteHost());
        }
        try {
            cid_conns = this.handler.getCIDConnections(cid_main, true);
        }
        catch (NotLocalhostException ex) {
            log.log(Level.FINER, "{0} Incorrect local hostname: {1}", new Object[]{serv, p});
            this.generateStreamError(false, "host-unknown", serv);
            return;
        }
        catch (LocalhostException ex) {
            log.log(Level.FINER, "{0} Incorrect remote hostname: {1}", new Object[]{serv, p});
            this.generateStreamError(false, "invalid-from", serv);
            return;
        }
        if (serv.connectionType() == ConnectionType.accept) {
            cid_conns.addIncoming(serv);
        }
        String remote_key = p.getElemCData();
        if (p.getElemName() == "result" || p.getElemName() == "db:result") {
            if (p.getType() == null) {
                String conn_sessionId = serv.getSessionId();
                this.handler.sendVerifyResult("db:verify", cid_main, cid_packet, null, conn_sessionId, null, p.getElemCData(), true);
            } else if (p.getType() == StanzaType.valid) {
                if (this.wasResultRequested(serv, p.getStanzaFrom().toString())) {
                    cid_conns.connectionAuthenticated(serv);
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Received result with type valid for {0} but it was not requested!", p.getStanzaFrom());
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Invalid result for DB authentication: {0}, stopping connection: {1}", new Object[]{cid_packet, serv});
                }
                serv.stop();
            }
        }
        if (p.getElemName() == "verify" || p.getElemName() == "db:verify") {
            if (p.getType() == null) {
                String local_key = this.handler.getLocalDBKey(cid_main, cid_packet, remote_key, p.getStanzaId(), serv.getSessionId());
                if (local_key == null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "The key is not available for connection CID: {0}, or the packet CID: {1} maybe it is located on a different node...", new Object[]{cid_main, cid_packet});
                    }
                } else {
                    this.handler.sendVerifyResult("db:verify", cid_main, cid_packet, local_key.equals(remote_key), p.getStanzaId(), serv.getSessionId(), null, false);
                }
            } else {
                if (this.wasVerifyRequested(serv, p.getStanzaFrom().toString())) {
                    this.handler.sendVerifyResult("db:result", cid_main, cid_packet, p.getType() == StanzaType.valid, null, p.getStanzaId(), null, false);
                    cid_conns.connectionAuthenticated(p.getStanzaId());
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "received verify for {0} but it was not requested!", p.getStanzaFrom());
                }
                if (serv.isHandshakingOnly()) {
                    serv.stop();
                }
            }
        }
    }

    private void addToResultRequested(S2SIOService serv, String domain) {
        Set<String> requested = (CopyOnWriteArraySet<String>)serv.getSessionData().get(REQUESTED_RESULT_DOMAINS_KEY);
        if (requested == null) {
            CopyOnWriteArraySet<String> requested_tmp = new CopyOnWriteArraySet<String>();
            requested = serv.getSessionData().putIfAbsent(REQUESTED_RESULT_DOMAINS_KEY, requested_tmp);
            if (requested == null) {
                requested = requested_tmp;
            }
        }
        requested.add(domain);
    }

    private boolean wasResultRequested(S2SIOService serv, String domain) {
        Set requested = (Set)serv.getSessionData().get(REQUESTED_RESULT_DOMAINS_KEY);
        return requested != null && requested.contains(domain);
    }

    private boolean wasVerifyRequested(S2SIOService serv, String domain) {
        String requested = (String)serv.getSessionData().get("handshaking-domain-key");
        return requested != null && requested.contains(domain);
    }

    private class AuthenticationTimer
    extends TimerTask {
        private S2SIOService serv = null;

        private AuthenticationTimer(S2SIOService serv) {
            this.serv = serv;
        }

        @Override
        public void run() {
            if (!this.serv.isAuthenticated() && this.serv.isConnected()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Connection not authenticated within timeout, stopping: {0}", this.serv);
                }
                this.serv.stop();
            }
        }
    }
}

