/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.server.ConnectionManager;
import tigase.server.xmppclient.StreamManagementIOProcessor;
import tigase.server.xmppclient.XMPPIOProcessor;

public class XMPPIOProcessorsFactory {
    private static final Logger log = Logger.getLogger(XMPPIOProcessorsFactory.class.getCanonicalName());
    private static final String IO_PROCESSORS_PROP_KEY = "processors";
    private static final Map<String, Class<? extends XMPPIOProcessor>> PROCESSORS = new HashMap<String, Class<? extends XMPPIOProcessor>>();

    public static XMPPIOProcessor[] updateIOProcessors(ConnectionManager connectionManager, XMPPIOProcessor[] activeProcessors, Map<String, Object> props) {
        if (props.containsKey(IO_PROCESSORS_PROP_KEY)) {
            String[] processorsArr = (String[])props.get(IO_PROCESSORS_PROP_KEY);
            ArrayList<XMPPIOProcessor> processors = new ArrayList<XMPPIOProcessor>();
            if (processorsArr != null) {
                for (String procId : processorsArr) {
                    XMPPIOProcessor proc = XMPPIOProcessorsFactory.findProcessor(activeProcessors, procId);
                    if (proc == null) continue;
                    proc.setConnectionManager(connectionManager);
                    Map<String, Object> procSettings = XMPPIOProcessorsFactory.getProcSettings(props, procId);
                    proc.setProperties(procSettings);
                    processors.add(proc);
                }
            }
            return processors.toArray(new XMPPIOProcessor[processors.size()]);
        }
        return activeProcessors;
    }

    public static Map<String, Object> getProcSettings(Map<String, Object> props, String procId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        String keyPrefix = "processors/" + procId;
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key;
            if (!entry.getKey().startsWith(keyPrefix) || (key = entry.getKey().replace(keyPrefix, "")) == null || key.isEmpty()) continue;
            results.put(key, entry.getValue());
        }
        return results;
    }

    public static XMPPIOProcessor findProcessor(XMPPIOProcessor[] activeProcessors, String procId) {
        for (XMPPIOProcessor proc : activeProcessors) {
            if (!procId.equals(proc.getId())) continue;
            return proc;
        }
        try {
            return PROCESSORS.get(procId).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        PROCESSORS.put("urn:xmpp:sm:3", StreamManagementIOProcessor.class);
    }
}

