/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.derby;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.util.Algorithms;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(StoredProcedures.class.getName());

    public static void tigActiveAccounts(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where account_status > 0");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigAddNode(long parentNid, long uid, String node, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("insert into tig_nodes (parent_nid, uid, node) values (?, ?, ?)", 1);
            ps.setLong(1, parentNid);
            ps.setLong(2, uid);
            ps.setString(3, node);
            ps.executeUpdate();
            data[0] = ps.getGeneratedKeys();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigAddUser(String userId, String userPw, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps_check = conn.prepareStatement("select uid from tig_users where lower(user_id)=?");
            ps_check.setString(1, userId.toLowerCase());
            ResultSet rs_check = ps_check.executeQuery();
            if (rs_check.next()) {
                return;
            }
            PreparedStatement ps = conn.prepareStatement("insert into tig_users (user_id, user_pw) values (?, ?)", 1);
            ps.setString(1, userId);
            ps.setString(2, userPw);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            long generatedKey = rs.getLong(1);
            PreparedStatement ps3 = conn.prepareStatement("select uid from tig_users where uid=?");
            ps3.setLong(1, generatedKey);
            data[0] = ps3.executeQuery();
            PreparedStatement ps2 = conn.prepareStatement("insert into tig_nodes (parent_nid, uid, node) values (NULL, ?, 'root')");
            ps2.setLong(1, generatedKey);
            ps2.executeUpdate();
            if (null == userPw) {
                PreparedStatement ps4 = conn.prepareStatement("update tig_users set account_status = -1 where uid = ?");
                ps4.setLong(1, generatedKey);
                ps4.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigAddUserPlainPw(String userId, String userPw, ResultSet[] data) throws SQLException {
        String encMethod = StoredProcedures.tigGetDBProperty("password-encoding");
        String encp = StoredProcedures.encodePassword(encMethod, userId, userPw);
        StoredProcedures.tigAddUser(userId, encp, data);
    }

    public static void tigAllUsers(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigAllUsersCount(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select count(*) as res_cnt from tig_users");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigDisableAccount(String userId) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("update tig_users set account_status = 0 where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigDisabledAccounts(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where account_status = 0");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigEnableAccount(String userId) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("update tig_users set account_status = 1 where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static String tigGetDBProperty(String key) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            String result = null;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("function tigGetDBProperty('" + key + "') called");
            }
            PreparedStatement ps = conn.prepareStatement("select pval from tig_pairs, tig_users where (pkey = ?) AND (user_id = 'db-properties') AND (tig_pairs.uid = tig_users.uid)");
            ps.setString(1, key.toLowerCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            String string = result;
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigGetPassword(String userId, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_pw from tig_users where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigGetUserDBUid(String userId, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select uid from tig_users where lower(user_id) = ?");
            ps.setString(1, userId.toLowerCase());
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigInitdb() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("update tig_users set online_status = 0");
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigOfflineUsers(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where online_status = 0");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigOnlineUsers(ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id, last_login, last_logout, online_status, failed_logins, account_status from tig_users where online_status > 0");
            data[0] = ps.executeQuery();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigPutDBProperty(String key, String value) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            int result;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("procedure tigPutDBProperty('" + key + "', '" + value + "') called");
            }
            if (StoredProcedures.tigGetDBProperty(key) != null) {
                PreparedStatement ps = conn.prepareStatement("update tig_pairs set tig_pairs.pval = ? where (pkey = ?) and uid = (select uid from tig_users where tig_users.user_id = 'db-properties')");
                ps.setString(1, value);
                ps.setString(2, key);
                result = ps.executeUpdate();
            } else {
                PreparedStatement ps = conn.prepareStatement("insert into tig_pairs (pkey, pval, uid) select ?, ?, uid from tig_users where (user_id = 'db-properties')");
                ps.setString(1, key);
                ps.setString(2, value);
                result = ps.executeUpdate();
            }
            if (result != 1) {
                log.severe("Error on put properties");
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigRemoveUser(String userId) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps3 = conn.prepareStatement("select uid from tig_users where lower(user_id) = ?");
            ps3.setString(1, userId.toLowerCase());
            ResultSet rs = ps3.executeQuery();
            rs.next();
            long uid = rs.getLong(1);
            PreparedStatement ps1 = conn.prepareStatement("delete from tig_pairs where uid = ?");
            ps1.setLong(1, uid);
            ps1.executeUpdate();
            PreparedStatement ps2 = conn.prepareStatement("delete from tig_nodes where uid = ?");
            ps2.setLong(1, uid);
            ps2.executeUpdate();
            PreparedStatement ps = conn.prepareStatement("delete from tig_users where uid = ?");
            ps.setLong(1, uid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigUpdatePairs(long nid, long uid, String key, String value) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select 1 from tig_pairs where nid = ? and uid = ? and pkey = ?");
            ps.setLong(1, nid);
            ps.setLong(2, uid);
            ps.setString(3, key);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PreparedStatement ps1 = conn.prepareStatement("update tig_pairs set pval = ? where nid = ? and uid = ? and pkey = ?");
                ps1.setString(1, value);
                ps1.setLong(2, nid);
                ps1.setLong(3, uid);
                ps1.setString(4, key);
                ps1.executeUpdate();
            } else {
                PreparedStatement ps1 = conn.prepareStatement("insert into tig_pairs (nid, uid, pkey, pval) values (?, ?, ?, ?)");
                ps1.setLong(1, nid);
                ps1.setLong(2, uid);
                ps1.setString(3, key);
                ps1.setString(4, value);
                ps1.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigUpdatePassword(String userId, String userPw) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("update tig_users set user_pw = ? where lower(user_id) = ?");
            ps.setString(1, userPw);
            ps.setString(2, userId.toLowerCase());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigUpdatePasswordPlainPw(String userId, String userPw) throws SQLException {
        String encMethod = StoredProcedures.tigGetDBProperty("password-encoding");
        String encp = StoredProcedures.encodePassword(encMethod, userId, userPw);
        StoredProcedures.tigUpdatePassword(userId, encp);
    }

    public static void tigUpdatePasswordPlainPwRev(String userPw, String userId) throws SQLException {
        StoredProcedures.tigUpdatePasswordPlainPw(userId, userPw);
    }

    public static void tigUserLogin(String userId, String userPw, ResultSet[] data) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("select user_id from tig_users where (account_status > 0) AND ( lower(user_id) = ?) AND (user_pw = ?)");
            ps.setString(1, userId.toLowerCase());
            ps.setString(2, userPw);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                PreparedStatement x = conn.prepareStatement("values '" + userId + "'");
                data[0] = x.executeQuery();
                PreparedStatement flps = conn.prepareStatement("update tig_users set online_status = online_status + 1, last_login = current timestamp where lower(user_id) =  ?");
                flps.setString(1, userId.toLowerCase());
                flps.executeUpdate();
            } else {
                PreparedStatement x = conn.prepareStatement("values '-'");
                data[0] = x.executeQuery();
                PreparedStatement flps = conn.prepareStatement("update tig_users set failed_logins = failed_logins + 1 where lower(user_id) = ?");
                flps.setString(1, userId.toLowerCase());
                flps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public static void tigUserLoginPlainPw(String userId, String userPw, ResultSet[] data) throws SQLException {
        String encMethod = StoredProcedures.tigGetDBProperty("password-encoding");
        String encp = StoredProcedures.encodePassword(encMethod, userId, userPw);
        StoredProcedures.tigUserLogin(userId, encp, data);
    }

    public static void tigUserLogout(String userId) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(2);
        try {
            PreparedStatement ps = conn.prepareStatement("update tig_users set online_status = online_status - 1, last_logout = current timestamp where lower(user_id) =  ?");
            ps.setString(1, userId.toLowerCase());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    private static String encodePassword(String encMethod, String userId, String userPw) {
        if (encMethod != null && "MD5-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userPw);
        }
        if (encMethod != null && "MD5-USERID-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userId + userPw);
        }
        if (encMethod != null && "MD5-USERNAME-PASSWORD".equals(encMethod)) {
            return StoredProcedures.md5(userId.substring(0, userId.indexOf("@")) + userPw);
        }
        return userPw;
    }

    private static String md5(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (data != null) {
                md.update(data.getBytes());
            }
            byte[] digest = md.digest();
            return Algorithms.bytesToHex(digest);
        }
        catch (Exception e) {
            throw new RuntimeException("Error on encoding password", e);
        }
    }
}

