/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.push.fcm.AccessToken;
import tigase.push.fcm.FcmBodyHandler;
import tigase.push.fcm.FcmUtil;

public class Credentials {
    private static final Logger a = Logger.getLogger(Credentials.class.getCanonicalName());
    private static final long b = TimeUnit.HOURS.toSeconds(1L);
    private final String c;
    private final String d;
    private final PrivateKey e;
    private final String f;
    private final String g;
    private final URI h;

    public static Credentials fromFile(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            Credentials credentials = Credentials.fromReader(bufferedReader);
            return credentials;
        }
    }

    public static Credentials fromString(String data) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return Credentials.fromReader(new StringReader(data));
    }

    public static Credentials fromReader(Reader reader) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Map map = (Map)new JsonSlurper().parse(reader);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(tigase.util.Base64.decode((String)Arrays.stream(((String)map.get("private_key")).split("\n")).filter(string -> !string.startsWith("--")).collect(Collectors.joining())));
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        return new Credentials((String)map.get("project_id"), (String)map.get("private_key_id"), privateKey, (String)map.get("client_email"), (String)map.get("auth_uri"), URI.create((String)map.get("token_uri")));
    }

    public Credentials(String projectId, String privateKeyId, PrivateKey privateKey, String clientEmail, String authUri, URI tokenUri) {
        this.c = projectId;
        this.d = privateKeyId;
        this.e = privateKey;
        this.f = clientEmail;
        this.g = authUri;
        this.h = tokenUri;
    }

    public String getProjectId() {
        return this.c;
    }

    public void refresh() {
    }

    public String toString() {
        return "Credentials{projectId='" + this.c + "', privateKeyId='" + this.d + "', privateKey=" + this.e + ", authUri='" + this.g + "', tokenUri='" + this.h + "'}";
    }

    protected String createAssertion() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = JsonOutput.toJson(Map.of("alg", "RS256", "typ", "JWT", "kid", this.d));
        String string2 = JsonOutput.toJson(Map.of("iss", this.f, "iat", System.currentTimeMillis() / 1000L, "exp", System.currentTimeMillis() / 1000L + b, "scope", "https://www.googleapis.com/auth/firebase.messaging", "aud", this.h.toASCIIString()));
        if (a.isLoggable(Level.FINEST)) {
            a.finest("generated assertion access token, header: " + string + ", payload: " + string2);
        }
        String string3 = Base64.getUrlEncoder().withoutPadding().encodeToString(string.getBytes(StandardCharsets.UTF_8)) + "." + Base64.getUrlEncoder().withoutPadding().encodeToString(string2.getBytes(StandardCharsets.UTF_8));
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(this.e);
        signature.update(string3.getBytes(StandardCharsets.UTF_8));
        String string4 = Base64.getUrlEncoder().withoutPadding().encodeToString(signature.sign());
        return string3 + "." + string4;
    }

    protected CompletableFuture<AccessToken> refreshToken(HttpClient client) {
        try {
            String string = this.createAssertion();
            HttpRequest httpRequest = HttpRequest.newBuilder(this.h).setHeader("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + string, StandardCharsets.UTF_8)).build();
            return client.sendAsync(httpRequest, FcmBodyHandler.ofMap()).thenApply(httpResponse -> {
                LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(FcmUtil.validateNumber((Map)httpResponse.body(), "expires_in").longValue());
                return new AccessToken(FcmUtil.validateString((Map)httpResponse.body(), "access_token"), localDateTime);
            });
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            return CompletableFuture.failedFuture(generalSecurityException);
        }
    }
}

