/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.LogManager;
import org.junit.Assert;
import org.junit.Test;
import tigase.push.Device;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPushSettings;
import tigase.push.fcm.FcmHttpV1Provider;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class FcmHttpV1ProviderTest {
    private final String deviceId = System.getProperty("deviceId");
    private final String serviceAccountPath = System.getProperty("serviceAccountPath");

    @Test
    public void testProvider() throws TigaseStringprepException, ExecutionException, InterruptedException, NoSuchFieldException, IllegalAccessException, IOException {
        if (this.deviceId == null || this.serviceAccountPath == null) {
            return;
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=java.util.logging.ConsoleHandler\ntigase.push.fcm.level=ALL\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST".getBytes()));
        FcmHttpV1Provider provider = new FcmHttpV1Provider();
        Field f = provider.getClass().getDeclaredField("serviceAccountPath");
        f.setAccessible(true);
        f.set(provider, this.serviceAccountPath);
        provider.beanConfigurationChanged(List.of("serviceAccountPath"));
        PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)"test@example.com"), INotification.Priority.low, Long.valueOf(5L), JID.jidInstance((String)"sender@example.com/resource-1"), "Some very important message " + UUID.randomUUID().toString(), null);
        Device device = new Device("dummy", this.deviceId, null);
        String id = (String)provider.pushNotification((IPushSettings.IDevice)device, (INotification)plainNotification).get();
        Assert.assertNotNull((String)"Failed to sent notification, id was returned as NULL!", (Object)id);
    }
}

