/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.modules;

import org.junit.Test;
import tigase.pubsub.Affiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

import java.util.ArrayDeque;
import java.util.Queue;

import static org.junit.Assert.assertEquals;
import static tigase.Assert.assertElementEquals;

/**
 * Created by andrzej on 04.01.2017.
 */
public class AffiliationChangedModuleTest {

	@Test
	public void test_notifyAffiliationChanged() throws Exception {
		Queue<Packet> results = new ArrayDeque<>();
		AffiliationChangedModule module = new AffiliationChangedModule() {
			@Override
			protected void write(Packet packet) {
				results.offer(packet);
			}
		};

		JID pushServiceJid = JID.jidInstance("push.example.com");
		JID userJid = JID.jidInstance("user@example.com");
		String node = "push-node";

		Element expected = new Element("message", new Element[]{new Element("pubsub", new Element[]{
				new Element("affiliation", new String[]{"jid", "affiliation"},
							new String[]{userJid.toString(), "none"})}, new String[]{"xmlns", "node"}, new String[]{
				"http://jabber.org/protocol/pubsub", node})}, new String[]{"xmlns", "from", "to"},
									   new String[]{"jabber:client", pushServiceJid.toString(), userJid.toString()});

		module.notifyAffiliationChanged(pushServiceJid.getBareJID(), userJid.getBareJID(), node, Affiliation.none);

		assertEquals(1, results.size());
		Element result = results.poll().getElement();
		assertElementEquals(expected, result);
	}

}
