/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.fcm;

import org.junit.Test;
import tigase.push.Device;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPushSettings;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.LogManager;

/**
 * Created by andrzej on 22.05.2017.
 */
public class FcmXmppApiProviderTest {

	private final String deviceId = System.getProperty("deviceId");
	private final String senderId = System.getProperty("senderId");
	private final String serverKey = System.getProperty("serverKey");

	@Test
	public void testProvider() throws NoSuchFieldException, IllegalAccessException, InterruptedException, IOException,
									  TigaseStringprepException {
		if (serverKey == null || senderId == null) {
			return;
		}

		LogManager.getLogManager()
				.readConfiguration(new ByteArrayInputStream(
						"handlers=java.util.logging.ConsoleHandler\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST"
								.getBytes()));
		FcmXmppApiProvider provider = new FcmXmppApiProvider();

		Field f = provider.getClass().getDeclaredField("serverKey");
		f.setAccessible(true);
		f.set(provider, serverKey);
		f = provider.getClass().getDeclaredField("senderId");
		f.setAccessible(true);
		f.set(provider, senderId);

		provider.beanConfigurationChanged(Arrays.asList("serverKey", "senderId"));

		Thread.sleep(3000);

		PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance("test@example.com"), INotification.Priority.low, 5l,
																	JID.jidInstance("sender@example.com/resource-1"),
																	"Some very important message " + UUID.randomUUID().toString(), null);
		IPushSettings.IDevice device = new Device("dummy", deviceId, null);
		provider.pushNotification(device, plainNotification);
		Thread.sleep(10000);
	}

}