/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.fcm;

import org.junit.Test;
import tigase.annotations.TigaseDeprecated;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.LogManager;

/**
 * Created by andrzej on 22.05.2017.
 */
@Deprecated
@TigaseDeprecated(removeIn = "9.0.0", since = "8.4.0", note = "XMPP FCM was deprecated by Google")
public class FcmConnectionTest {

	private final String deviceId = System.getProperty("deviceId");
	private final String senderId = System.getProperty("senderId");
	private final String serverKey = System.getProperty("serverKey");

	@Test
	public void testConnection() throws InterruptedException, IOException {
		if (serverKey == null || senderId == null) {
			return;
		}

		LogManager.getLogManager()
				.readConfiguration(new ByteArrayInputStream(
						"handlers=java.util.logging.ConsoleHandler\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST"
								.getBytes()));
		FcmConnection conn = new FcmConnection(serverKey, senderId, true);
		conn.setProvider(new FcmProvider() {
			@Override
			public void connected(FcmConnection conn) {
				System.out.println("Connection established " + conn);

				try {
					conn.sendNotification("{\"to\":\"" + deviceId + "\",\"dry_run\":true, \"message_id\":\"" +
												  UUID.randomUUID().toString() +
												  "\"\"data\":{\"body\":\"Yellow or green?\"},\"priority\":10}");
				} catch (JaxmppException e) {
					e.printStackTrace();
				}
			}

			@Override
			public void disconnected(FcmConnection conn) {
				System.out.println("Connection broken " + conn);
			}

			@Override
			public void unregisterDevice(String deviceId) {
				System.out.println("Device " + deviceId + " unregistered");
			}
		});
		conn.start();

		Thread.sleep(60 * 1000);
	}

}