/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.apns;

import groovy.json.JsonSlurper;
import junit.framework.TestCase;
import org.junit.Test;

import java.util.List;
import java.util.Map;

public class ApnsPayloadTest
		extends TestCase {

	@Test
	public void testJsonEscaping() {
		String body = "To be, \\ or \"not\" to \b\t\r be:\n that is / the question";
		ApnsPayload payload = ApnsPayload.newBuilder().body(body).category("test").customField("test-1", List.of("xx", "yy")).build();
		String payloadString = payload.toPayloadString();
		Map<String, Object> result = (Map<String, Object>) new JsonSlurper().parseText(payloadString);
		assertNotNull(result);
		Map<String, Object> aps = (Map<String, Object>) result.get("aps");
		assertNotNull(aps);
		Map<String, Object> alert = (Map<String, Object>) aps.get("alert");
		assertNotNull(alert);
		assertEquals(body, alert.get("body"));
	}

}