/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.repositories;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.util.Version;

import java.util.Optional;

/**
 * Created by andrzej on 03.01.2017.
 */
public class InMemoryPushRepositoryTest
		extends AbstractIPushRepositoryTest {

	private static InMemoryPushRepository singleton;

	@BeforeClass
	public static void setUpSingleton() {
		singleton = new InMemoryPushRepository();
	}

	@AfterClass
	public static void tearDownSingleton() {
		singleton = null;
	}

	@Before
	public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
		repository = singleton;
	}

	@Override
	public void cleanUp() {
		repository = null;
	}

	@Override
	protected DataSource prepareDataSource() throws DBInitException, IllegalAccessException, InstantiationException {
		return new DataSource() {
			@Override
			public Optional<Version> getSchemaVersion(String component) {
				return null;
			}

			@Override
			public String getResourceUri() {
				return null;
			}

			@Override
			public void initialize(String resource_uri) throws RepositoryException {

			}
		};
	}

	@Override
	protected DataSourceAware prepareDataSourceAware() throws Exception {
		return null;
	}

}
