/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.apns;

import org.junit.Test;
import tigase.push.Device;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPushSettings;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.LogManager;

import static org.junit.Assert.assertNotNull;

public class APNSProviderTest {

	// old tokens are still active even if I do not have the device for it?
	private final String deviceId = System.getProperty("deviceId");
	private final String certificatePath = System.getProperty("certPath");
	private final String certificatePassword = System.getProperty("certPass");

	@Test
	public void testProvider() throws NoSuchFieldException, IllegalAccessException, InterruptedException, IOException,
									  TigaseStringprepException, ExecutionException {
		if (certificatePath == null) {
			return;
		}
		
		LogManager.getLogManager()
				.readConfiguration(new ByteArrayInputStream(
						"handlers=java.util.logging.ConsoleHandler\ntigase.push.apns.level=ALL\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST"
								.getBytes()));

		APNsBinaryApiProvider provider = new APNsBinaryApiProvider();

		Field f = provider.getClass().getDeclaredField("certificatePath");
		f.setAccessible(true);
		f.set(provider, certificatePath);
		f = provider.getClass().getDeclaredField("certificatePassword");
		f.setAccessible(true);
		f.set(provider, certificatePassword);
		f = provider.getClass().getDeclaredField("fallbackToSandbox");
		f.setAccessible(true);
		f.set(provider, true);
		f = provider.getClass().getDeclaredField("apnsTopic");
		f.setAccessible(true);
		f.set(provider, "org.tigase.messenger.mobile");

		provider.beanConfigurationChanged(Arrays.asList("certificatePath"));


//		Notification notification = new Notification(BareJID.bareJIDInstance("test@example.com"), 5l,
//													 JID.jidInstance("sender@example.com/resource-1"),
//													 "Some very important message " + UUID.randomUUID().toString(), null);

		IPushSettings.IDevice device = new Device("dummy", deviceId, null);
		for (int i=0; i<1; i++) {
//			PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance("andrzej.wojcik@tigase.org"), INotification.Priority.high, null,
//																		null,
//																		"New message 123!", null);
			PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance("andrzej@hi-low.eu"), INotification.Priority.high, 1l,
																		JID.jidInstance("home@hi-low.eu"),
																		"Some very important message " + UUID.randomUUID().toString(), null);

			CompletableFuture<String> future = provider.pushNotification(device, plainNotification);
			String apnsId = future.get();
			assertNotNull("APNS ID is NULL!", apnsId);
			System.out.println("send push notification with id " + apnsId);
		}
		Thread.sleep(1000);
	}

}
