/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.repositories.derby;

import java.sql.*;

/**
 * Created by andrzej on 15.05.2017.
 */
public class StoredProcedures {

	public static void tigPushGetNodeSettingsByDevice(String provider, String deviceId, ResultSet[] data)
			throws SQLException {
		Connection conn = DriverManager.getConnection("jdbc:default:connection");

		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

		try {
			PreparedStatement ps = conn.prepareStatement(
					"select pd.service_jid, pd.user_jid, pd.node, pd.provider, pd.device_id, pd.device_second_id" +
							" from tig_push_devices pd" + " where" + " pd.provider = ?" + " and pd.device_id = ?");

			ps.setString(1, provider);
			ps.setString(2, deviceId);
			data[0] = ps.executeQuery();
		} catch (SQLException e) {
			// e.printStackTrace();
			// log.log(Level.SEVERE, "SP error", e);
			throw e;
		} finally {
			conn.close();
		}
	}

	public static void tigPushGetNodeSettingsByNode(String serviceJid, String node, ResultSet[] data)
			throws SQLException {
		Connection conn = DriverManager.getConnection("jdbc:default:connection");

		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

		try {
			PreparedStatement ps = conn.prepareStatement(
					"select pd.user_jid, pd.provider, pd.device_id, pd.device_second_id" + " from tig_push_devices pd" + " where" +
							" pd.service_jid = ?" + " and pd.node = ?");

			ps.setString(1, serviceJid);
			ps.setString(2, node);
			data[0] = ps.executeQuery();
		} catch (SQLException e) {
			// e.printStackTrace();
			// log.log(Level.SEVERE, "SP error", e);
			throw e;
		} finally {
			conn.close();
		}
	}

	public static void tigPushRegisterDevice(String serviceJid, String userJid, String node, String provider,
											 String deviceId, String deviceSecondId) throws SQLException {
		Connection conn = DriverManager.getConnection("jdbc:default:connection");

		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

		try {
			PreparedStatement ps = conn.prepareStatement("select 1 from tig_push_devices where service_jid = ? and node = ?");
			ps.setString(1, serviceJid);
			ps.setString(2, node);
			ResultSet rs = ps.executeQuery();
			rs.close();
			boolean exists = rs.next();
			if (exists) {
				PreparedStatement ps1 = conn.prepareStatement("update tig_push_devices set device_second_id = ? where service_jid = ? and node = ? and user_jid = ?");
				ps1.setString(1, deviceSecondId);
				ps1.setString(2, serviceJid);
				ps1.setString(3, node);
				ps1.setString(4,userJid);
				ps1.executeUpdate();
			} else {
				PreparedStatement ps1 = conn.prepareStatement(
						"insert into tig_push_devices (service_jid, user_jid, node, provider, device_id, device_second_id)" +
								" values (?, ?, ?, ?, ?, ?)", Statement.RETURN_GENERATED_KEYS);

				ps1.setString(1, serviceJid);
				ps1.setString(2, userJid);
				ps1.setString(3, node);
				ps1.setString(4, provider);
				ps1.setString(5, deviceId);
				ps1.executeUpdate();
			}
		} catch (SQLException e) {

			// e.printStackTrace();
			// log.log(Level.SEVERE, "SP error", e);
			throw e;
		} finally {
			conn.close();
		}
	}

	public static void tigPushUnregisterDevice(String serviceJid, String userJid, String node, String provider,
											   String deviceId) throws SQLException {
		Connection conn = DriverManager.getConnection("jdbc:default:connection");

		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

		try {
			PreparedStatement ps = conn.prepareStatement("delete from tig_push_devices" +
																 " where service_jid = ? and user_jid = ? and node = ? and provider = ? and device_id = ?");

			ps.setString(1, serviceJid);
			ps.setString(2, userJid);
			ps.setString(3, node);
			ps.setString(4, provider);
			ps.setString(5, deviceId);
			ps.executeUpdate();
		} catch (SQLException e) {

			// e.printStackTrace();
			// log.log(Level.SEVERE, "SP error", e);
			throw e;
		} finally {
			conn.close();
		}
	}

	public static void tigPushStats(ResultSet[] data)
			throws SQLException {
		Connection conn = DriverManager.getConnection("jdbc:default:connection");

		conn.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

		try {
			PreparedStatement ps = conn.prepareStatement(
					"select 'all', provider, count(1) from tig_push_devices group by provider union all select 'accounts', provider, count(distinct user_jid) from tig_push_devices group by provider, user_jid");

			data[0] = ps.executeQuery();
		} catch (SQLException e) {
			// e.printStackTrace();
			// log.log(Level.SEVERE, "SP error", e);
			throw e;
		} finally {
			conn.close();
		}
	}
}
