/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.monitor;

import java.time.LocalDateTime;
import java.util.stream.Stream;

public interface SSLCertificateExpirationAware {

	Stream<Result> getSSLCertificatesValidPeriod();

	class Result {

		private final String name;
		private final LocalDateTime validFrom;
		private final LocalDateTime validTo;

		public Result(String name, LocalDateTime validFrom, LocalDateTime validTo) {
			this.name = name;
			this.validFrom = validFrom;
			this.validTo = validTo;
		}

		public String getName() {
			return name;
		}

		public LocalDateTime getValidFrom() {
			return validFrom;
		}

		public LocalDateTime getValidTo() {
			return validTo;
		}

		public boolean isValid(LocalDateTime date) {
			return validFrom.isBefore(date) && validTo.isAfter(date);
		}
	}
}
