/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.modules;

import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.Affiliation;
import tigase.push.PushNotificationsComponent;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import static tigase.server.Message.ELEM_NAME;
import static tigase.server.Packet.CLIENT_XMLNS;

/**
 * Created by andrzej on 04.01.2017.
 */
@Bean(name = "affiliation-changed", parent = PushNotificationsComponent.class, active = true)
public class AffiliationChangedModule
		extends AbstractModule {

	@Override
	public String[] getFeatures() {
		return null;
	}

	@Override
	public Criteria getModuleCriteria() {
		return null;
	}

	@Override
	public void process(Packet packet) throws ComponentException, TigaseStringprepException {
		throw new ComponentException(Authorization.BAD_REQUEST);
	}

	public void notifyAffiliationChanged(BareJID pushServiceJid, BareJID userJid, String node,
										 Affiliation affiliation) {
		Element message = new Element(ELEM_NAME, new String[]{"xmlns"}, new String[]{CLIENT_XMLNS});
		Element pubsub = new Element("pubsub", new String[]{"xmlns", "node"},
									 new String[]{"http://jabber.org/protocol/pubsub", node});
		message.addChild(pubsub);
		pubsub.addChild(new Element("affiliation", new String[]{"jid", "affiliation"},
									new String[]{userJid.toString(), affiliation.name()}));

		write(Packet.packetInstance(message, JID.jidInstance(pushServiceJid), JID.jidInstance(userJid)));
	}
}
