/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.apns;

import tigase.component.exceptions.ComponentException;

public class ApnsServiceException extends ComponentException {

	private final ApnsService.ErrorCode errorCode;
	private final ApnsService.ErrorType errorType;

	public ApnsServiceException(ApnsService.ErrorCode errorCode, ApnsService.ErrorType errorType) {
		super(errorType.getErrorCondition());
		this.errorCode = errorCode;
		this.errorType = errorType;
	}

	public ApnsService.ErrorCode getErrorCode() {
		return errorCode;
	}

	public ApnsService.ErrorType getErrorType() {
		return errorType;
	}

	public boolean isErrorType(ApnsService.ErrorType errorType) {
		return this.errorType == errorType;
	}
	
	@Override
	public String toString() {
		return super.toString() + ", APNS Error: {errorCode=" + errorCode + ", errorType=" + errorType + '}';
	}
}
