/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.api;

import tigase.xmpp.jid.BareJID;

import java.util.List;

/**
 * Created by andrzej on 02.01.2017.
 */
public interface IPushSettings {

	int getVersion();

	List<IDevice> getDevices();

	String getNode();

	BareJID getOwnerJid();

	BareJID getServiceJid();

	default boolean isOwner(BareJID jid) {
		return jid != null && jid.equals(getOwnerJid());
	}

	IPushSettings addDevice(IDevice device);

	IPushSettings removeDevice(IDevice device);

	interface IDevice {

		String getDeviceId();

		String getDeviceSecondId();

		String getProviderName();

	}
}
