/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.api;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.xmpp.jid.BareJID;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

/**
 * Created by andrzej on 02.01.2017.
 */
public interface IPushRepository<DS extends DataSource>
		extends DataSourceAware<DS> {

	IPushSettings registerDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId, String deviceSecondToken)
			throws RepositoryException;

	IPushSettings unregisterDevice(BareJID serviceJid, BareJID userJid, String provider, String deviceId)
			throws RepositoryException, ComponentException;

	IPushSettings getNodeSettings(BareJID serviceJid, String node) throws RepositoryException;

	Stream<IPushSettings> getNodeSettings(BareJID userJid, String provider, String deviceId) throws RepositoryException;

	Stream<IPushSettings> getNodeSettings(String provider, String deviceId) throws RepositoryException;

	default IPushSettings getNodeSettings(BareJID serviceJid, String node, ElseHandler elseHandler)
			throws RepositoryException, ComponentException {
		IPushSettings pushSettings = getNodeSettings(serviceJid, node);
		if (pushSettings == null) {
			elseHandler.orElse(serviceJid, node);
		}
		return pushSettings;
	}

	default Map<String,Statistics> getStatistics() throws RepositoryException {
		return Collections.emptyMap();
	}

	interface ElseHandler {

		void orElse(BareJID serviceJid, String node) throws ComponentException;
	}

	interface Statistics {
		Map<String,Integer> getCounters();

		Collection<String> getCounterNames();

		int getCounterValue(String name);
	}
}
