/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.api;

import tigase.xmpp.impl.push.EncryptedPushNotificationExtension;
import tigase.xmpp.impl.push.PushNotifications;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

/**
 * Created by andrzej on 31.12.2016.
 */
public interface IPushProvider {

	String getName();

	String getDescription();

	/**
	 * @param device
	 * @param notification
	 * @return notification ID as String
	 */
	CompletableFuture<String> pushNotification(IPushSettings.IDevice device, INotification notification);

	default Optional<Integer> maxPayloadSize() {
		return Optional.empty();
	}

	default Set<Feature> supportedFeatures() {
		return Set.of(Feature.plain);
	}

	public enum Feature {
		plain(PushNotifications.XMLNS),
		encrypted(EncryptedPushNotificationExtension.XMLNS);

		private final String xmlns;

		Feature(String xmlns) {
			this.xmlns = xmlns;
		}

		public String getXMLNS() {
			return xmlns;
		}
	}
}
