/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.api;

import tigase.xmpp.jid.JID;

public interface IPlainNotification extends INotification {

	Long getMessageCount();

	JID getLastMessageSender();

	String getLastMessageBody();

	default void ifMessageCount(Processor<Long> processor) {
		Long messageCount = getMessageCount();
		if (messageCount != null) {
			processor.process(messageCount);
		}
	}

	default void ifLastMessageSender(Processor<JID> processor) {
		JID lastMessageSender = getLastMessageSender();
		if (lastMessageSender != null) {
			processor.process(lastMessageSender);
		}
	}

	default void ifLastMessageBody(Processor<String> processor) {
		String lastMessageBody = getLastMessageBody();
		if (lastMessageBody != null) {
			processor.process(lastMessageBody);
		}
	}

	default void ifGroupchatSenderNickname(Processor<String> processor) {
		String nickname = getGroupchatSenderNickname();
		if (nickname != null) {
			processor.process(nickname);
		}
	}

	String getGroupchatSenderNickname();

}
