/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.adhoc;

import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Form;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Created by andrzej on 02.01.2017.
 */
public abstract class AbstractAdHocCommand
		implements AdHocCommand {

	private static final Logger log = Logger.getLogger(AbstractAdHocCommand.class.getCanonicalName());

	@Override
	public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
		try {
			final Element data = request.getCommand().getChild("x", "jabber:x:data");

			if (request.isAction("cancel")) {
				response.cancelSession();
			} else {
				if (data == null) {
					response.getElements().add(prepareForm(request, response).getElement());
					response.startSession();
				} else {
					Form form = new Form(data);
					if (form.isType("submit")) {
						Form responseForm = submitForm(request, response, form);
						if (responseForm != null) {
							response.getElements().add(responseForm.getElement());
						}
					}
				}
			}
		} catch (AdHocCommandException ex) {
			throw ex;
		} catch (Exception e) {
			log.log(Level.FINE, "Exception during execution of adhoc command " + getNode(), e);
			throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
		}
	}

	protected abstract Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException;

	protected abstract Form submitForm(AdhHocRequest request, AdHocResponse response, Form form)
			throws AdHocCommandException;
}
