/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push;

import tigase.push.api.IPushSettings;
import tigase.xmpp.jid.BareJID;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by andrzej on 02.01.2017.
 */
public class PushSettings
		implements IPushSettings {

	protected final List<IDevice> devices;
	private final String node;
	private final BareJID ownerJid;
	private final BareJID serviceJid;
	private final int version;

	public PushSettings(int version, BareJID serviceJid, String node, BareJID ownerJid, List<IDevice> devices) {
		this.version = version;
		this.serviceJid = serviceJid;
		this.node = node;
		this.ownerJid = ownerJid;
		this.devices = devices;
		if (version > 0 && devices.size() > 1) {
			throw new InvalidParameterException("Version " + getVersion() + " supports only 1 device per node!");
		}
	}

	@Override
	public int getVersion() {
		return version;
	}

	@Override
	public List<IDevice> getDevices() {
		return Collections.unmodifiableList(devices);
	}

	@Override
	public String getNode() {
		return node;
	}

	@Override
	public BareJID getOwnerJid() {
		return ownerJid;
	}

	@Override
	public BareJID getServiceJid() {
		return serviceJid;
	}

	@Override
	public IPushSettings addDevice(IDevice device) {
		if (getVersion() > 0) {
			throw new UnsupportedOperationException("Unsupported operation for Push Settings v" + getVersion());
		}
		if (devices.contains(device)) {
			return this;
		}

		List<IDevice> devices = new ArrayList<>(this.devices);
		devices.add(device);
		return new PushSettings(getVersion(), serviceJid, node, ownerJid, devices);
	}

	@Override
	public IPushSettings removeDevice(IDevice device) {
		if (getVersion() > 0) {
			throw new UnsupportedOperationException("Unsupported operation for Push Settings v" + getVersion());
		}
		if (!devices.contains(device)) {
			return this;
		}

		List<IDevice> devices = new ArrayList<>(this.devices);
		devices.remove(device);
		return new PushSettings(getVersion(), serviceJid, node, ownerJid, devices);
	}

}
