/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push;

import tigase.push.api.IPlainNotification;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

/**
 * Created by andrzej on 02.01.2017.
 */
public class PlainNotification
		implements IPlainNotification {

	private final BareJID account;
	private final String lastMessageBody;
	private final JID lastMessageSender;
	private final Long messageCount;
	private final String groupchatSenderNickname;
	private final Priority priority;

	public PlainNotification(BareJID account, Priority priority, Long messageCount, JID lastMessageSender, String lastMessageBody, String groupchatSenderNickname) {
		this.account = account;
		this.priority = priority;
		this.messageCount = messageCount;
		this.lastMessageSender = lastMessageSender;
		this.lastMessageBody = lastMessageBody;
		this.groupchatSenderNickname = groupchatSenderNickname;
	}

	@Override
	public Long getMessageCount() {
		return messageCount;
	}

	@Override
	public JID getLastMessageSender() {
		return lastMessageSender;
	}

	@Override
	public String getLastMessageBody() {
		return lastMessageBody;
	}

	@Override
	public BareJID getAccount() {
		return account;
	}

	@Override
	public Priority getPriority() {
		return priority;
	}

	@Override
	public String getGroupchatSenderNickname() {
		return groupchatSenderNickname;
	}

	@Override
	public Type getType() {
		return Type.normal;
	}
}
