/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push;

import tigase.push.api.IEncryptedNotification;
import tigase.xmpp.jid.BareJID;

public class EncryptedNotification implements IEncryptedNotification {

	private final BareJID account;
	private final String encrypted;
	private final Priority priority;
	private final String iv;
	private final Type type;

	public EncryptedNotification(BareJID account, Priority priority, Type type, String encryped, String iv) {
		this.account = account;
		this.priority = priority;
		this.type = type;
		this.encrypted = encryped;
		this.iv = iv;
	}

	public BareJID getAccount() {
		return account;
	}

	@Override
	public String getEncrypted() {
		return encrypted;
	}

	public String getIV() {
		return iv;
	}

	@Override
	public Priority getPriority() {
		return priority;
	}

	@Override
	public Type getType() {
		return type;
	}
}
