/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push;

import tigase.push.api.IPushSettings;

/**
 * Created by andrzej on 02.01.2017.
 */
public class Device
		implements IPushSettings.IDevice {

	private final String deviceId;
	private final String deviceSecondId;
	private final String provider;

	public Device(String provider, String deviceId, String deviceSecondId) {
		this.provider = provider;
		this.deviceId = deviceId;
		this.deviceSecondId = deviceSecondId;
	}

	@Override
	public String getDeviceId() {
		return deviceId;
	}

	@Override
	public String getDeviceSecondId() {
		return deviceSecondId;
	}

	@Override
	public String getProviderName() {
		return provider;
	}

	@Override
	public int hashCode() {
		return deviceId.hashCode() * 31 + provider.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof IPushSettings.IDevice) {
			IPushSettings.IDevice o = (IPushSettings.IDevice) obj;
			return hashCode() == o.hashCode() && getDeviceId().equals(o.getDeviceId()) &&
					getProviderName().equals(o.getProviderName());
		}
		return false;
	}
}
