/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.modules;

import java.util.ArrayDeque;
import org.junit.Test;
import tigase.Assert;
import tigase.pubsub.Affiliation;
import tigase.push.modules.AffiliationChangedModule;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class AffiliationChangedModuleTest {
    @Test
    public void test_notifyAffiliationChanged() throws Exception {
        final ArrayDeque results = new ArrayDeque();
        AffiliationChangedModule module = new AffiliationChangedModule(){

            protected void write(Packet packet) {
                results.offer(packet);
            }
        };
        JID pushServiceJid = JID.jidInstance((String)"push.example.com");
        JID userJid = JID.jidInstance((String)"user@example.com");
        String node = "push-node";
        Element expected = new Element("message", new Element[]{new Element("pubsub", new Element[]{new Element("affiliation", new String[]{"jid", "affiliation"}, new String[]{userJid.toString(), "none"})}, new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/pubsub", node})}, new String[]{"xmlns", "from", "to"}, new String[]{"jabber:client", pushServiceJid.toString(), userJid.toString()});
        module.notifyAffiliationChanged(pushServiceJid.getBareJID(), userJid.getBareJID(), node, Affiliation.none);
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Element result = ((Packet)results.poll()).getElement();
        Assert.assertElementEquals((Element)expected, (Element)result);
    }
}

