/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import groovy.json.JsonSlurper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import tigase.push.apns.ApnsDelegate;
import tigase.push.apns.ApnsNotification;

public class ApnsService {
    private static final Logger a = Logger.getLogger(ApnsService.class.getCanonicalName());
    private static final int b = 3;
    private final ApnsDelegate c;
    private final String d;
    private final HttpClient e;

    private ApnsService(Builder builder) throws IOException {
        try {
            this.c = builder.c;
            this.d = builder.f;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("sunx509");
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            TrustManager[] trustManagerArray2 = new TrustManager[trustManagerArray.length + 1];
            for (int i = 0; i < trustManagerArray.length; ++i) {
                trustManagerArray2[i + 1] = trustManagerArray[i];
            }
            trustManagerArray2[0] = new SSLTrustManager(trustManagerFactory.getTrustManagers());
            sSLContext.init(builder.d.getKeyManagers(), trustManagerArray2, null);
            HttpClient.Builder builder2 = HttpClient.newBuilder().sslContext(sSLContext);
            if (builder.e != null) {
                builder2.executor(builder.e);
            }
            this.e = builder2.version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
        }
        catch (Exception exception) {
            throw new IOException("Could not initialize HttpClient", exception);
        }
    }

    public void push(ApnsNotification notification) {
        this.a(notification, 1);
    }

    private void a(ApnsNotification apnsNotification, int n) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Pushing notification: " + apnsNotification.toString());
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create("https://" + this.d + "/3/device/" + apnsNotification.getDeviceId())).POST(HttpRequest.BodyPublishers.ofString(apnsNotification.getPayload().toPayloadString())).header("apns-push-type", apnsNotification.getPushType().name()).header("apns-id", apnsNotification.getId()).header("apns-expiration", "0").header("apns-priority", String.valueOf(apnsNotification.getPriority()));
        if (apnsNotification.getCollapseId() != null) {
            builder.header("apns-collapse-id", apnsNotification.getCollapseId());
        }
        if (apnsNotification.getTopic() != null) {
            builder.header("apns-topic", apnsNotification.getTopic());
        }
        builder.timeout(Duration.ofSeconds(10L));
        HttpRequest httpRequest = builder.build();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Push request builder: " + httpRequest + ", with headers: " + httpRequest.headers());
        }
        ((CompletableFuture)this.e.sendAsync(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(Charset.forName("UTF-8"))).thenAccept(httpResponse -> {
            if (this.c != null) {
                ErrorCode errorCode;
                String string = httpResponse.headers().firstValue("apns-id").get();
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "GOT response " + httpResponse.statusCode() + " " + (String)httpResponse.body() + " apns-id " + string);
                }
                if ((errorCode = ErrorCode.fromStatus(httpResponse.statusCode())) == null) {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "sent notification: " + apnsNotification.toString());
                    }
                    this.c.messageSent(apnsNotification);
                } else {
                    Map map2 = (Map)new JsonSlurper().parse((Reader)new StringReader((String)httpResponse.body()));
                    ErrorType errorType = Optional.ofNullable(map2).map(map -> map.get("reason")).map(Object::toString).map(ErrorType::from).orElse(ErrorType.unknownError);
                    a.log(errorCode == ErrorCode.deviceTokenInactive || errorCode == ErrorCode.tooManyRequestsForDeviceToken || errorCode == ErrorCode.badRequest ? Level.FINER : Level.WARNING, "failed to send notification: " + apnsNotification.toString() + ", error: " + errorCode.name() + ", response: " + (String)httpResponse.body() + " will retry: " + (errorType.shouldRetry() && n < 3));
                    if (errorType.shouldRetry() && n < 3) {
                        this.a(apnsNotification, n + 1);
                    } else {
                        this.c.messageSendFailed(apnsNotification, errorCode, errorType);
                    }
                }
            }
        })).exceptionally(throwable -> {
            a.log(Level.FINEST, "failed to send notification: " + apnsNotification.toString() + " at " + this + ", exception thrown!", (Throwable)throwable);
            if (n < 3) {
                this.a(apnsNotification, n + 1);
            } else {
                a.log(Level.FINEST, "failed to send notification: " + apnsNotification.toString() + " at " + this + ", tried " + (n - 1) + " and still failing, dropping notification!");
            }
            return null;
        });
    }

    public void stop() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class SSLTrustManager
    implements X509TrustManager {
        private static final String[] a = new String[]{"c0554bde87a075ec13a61f275983ae023957294b454caf0a9724e3b21b7935bc", "56e98deac006a729afa2ed79f9e419df69f451242596d2aaf284c74a855e352e", "7289c06dedd16b71a7dcca66578572e2e109b11d70ad04c2601b6743bc66d07b", "fae46000d8f7042558541e98acf351279589f83b6d3001c18442e4403d111849", "b5cf82d47ef9823f9aa78f123186c52e8879ea84b0f822c91d83e04279b78fd5", "e24f8e8c2185da2f5e88d4579e817c47bf6eafbc8505f0f960fd5a0df4473ad3", "3174d9092f9531c06026ba489891016b436d5ec02623f9aafe2009ecc3e4d557"};
        private static final byte[][] b = (byte[][])Arrays.stream(a).map(SSLTrustManager::hexDecode).toArray(n -> new byte[n][]);
        private final TrustManager[] c;

        public SSLTrustManager(TrustManager[] trustManagers) {
            this.c = trustManagers;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Optional<X509TrustManager> optional = Arrays.stream(this.c).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.checkCertificateChainFingerprint(chain)) {
                return;
            }
            Optional<X509TrustManager> optional = Arrays.stream(this.c).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst();
            if (optional.isEmpty()) {
                throw new CertificateException("Could not verify certificate validity");
            }
            optional.get().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        protected boolean checkCertificateChainFingerprint(X509Certificate[] chain) {
            try {
                for (int i = 0; i < chain.length; ++i) {
                    if (!this.checkCerificateFingerprint(chain[i])) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                a.log(Level.FINEST, "Could not check certificate fingerprint", throwable);
            }
            return false;
        }

        protected boolean checkCerificateFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
            byte[] byArray = SSLTrustManager.sha256(certificate.getPublicKey().getEncoded());
            return Arrays.stream(b).anyMatch(byArray2 -> Arrays.equals(byArray2, byArray));
        }

        public static byte[] hexDecode(String hex) {
            int n = hex.length();
            byte[] byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byArray[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            }
            return byArray;
        }

        public static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return messageDigest.digest(data);
        }
    }

    public static enum ErrorType {
        badCollapseId,
        badDeviceToken,
        badExpirationDate,
        badMessageId,
        badPriority,
        badTopic,
        deviceTokenNotForTopic,
        duplicatedHeaders,
        idleTimeout,
        invalidPushType,
        missingDeviceToken,
        missingTopic,
        payloadEmpty,
        topicDisallowed,
        badCertificate,
        badCertificateEnvironment,
        expiredProviderToken,
        forbidden,
        invalidProviderToken,
        missingProviderToken,
        badPath,
        methodNotAllowed,
        unregistred,
        payloadTooLarge,
        tooManyProviderTokenUpdates,
        tooManyRequests,
        internalServerError,
        serviceUnavailable,
        shutdown,
        unknownError;


        public static ErrorType from(String type) {
            if (type == null) {
                return unknownError;
            }
            switch (type) {
                case "BadCollapseId": {
                    return badCollapseId;
                }
                case "BadDeviceToken": {
                    return badDeviceToken;
                }
                case "BadExpirationDate": {
                    return badExpirationDate;
                }
                case "BadMessageId": {
                    return badMessageId;
                }
                case "BadPriority": {
                    return badPriority;
                }
                case "BadTopic": {
                    return badTopic;
                }
                case "DeviceTokenNotForTopic": {
                    return deviceTokenNotForTopic;
                }
                case "DuplicateHeaders": {
                    return duplicatedHeaders;
                }
                case "IdleTimeout": {
                    return idleTimeout;
                }
                case "InvalidPushType": {
                    return invalidPushType;
                }
                case "MissingDeviceToken": {
                    return missingDeviceToken;
                }
                case "MissingTopic": {
                    return missingTopic;
                }
                case "PayloadEmpty": {
                    return payloadEmpty;
                }
                case "TopicDisallowed": {
                    return topicDisallowed;
                }
                case "BadCertificate": {
                    return badCertificate;
                }
                case "BadCertificateEnvironment": {
                    return badCertificateEnvironment;
                }
                case "ExpiredProviderToken": {
                    return expiredProviderToken;
                }
                case "Forbidden": {
                    return forbidden;
                }
                case "InvalidProviderToken": {
                    return invalidProviderToken;
                }
                case "MissingProviderToken": {
                    return missingProviderToken;
                }
                case "BadPath": {
                    return badPath;
                }
                case "MethodNotAllowed": {
                    return methodNotAllowed;
                }
                case "Unregistered": {
                    return unregistred;
                }
                case "PayloadTooLarge": {
                    return payloadTooLarge;
                }
                case "TooManyProviderTokenUpdates": {
                    return tooManyProviderTokenUpdates;
                }
                case "TooManyRequests": {
                    return tooManyRequests;
                }
                case "InternalServerError": {
                    return internalServerError;
                }
                case "ServiceUnavailable": {
                    return serviceUnavailable;
                }
                case "Shutdown": {
                    return shutdown;
                }
            }
            return unknownError;
        }

        public boolean shouldRetry() {
            switch (this) {
                case internalServerError: 
                case serviceUnavailable: 
                case shutdown: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum ErrorCode {
        badRequest,
        authenticationFailure,
        invalidMethod,
        deviceTokenInactive,
        payloadTooLarge,
        tooManyRequestsForDeviceToken,
        internalServerError,
        serverShutdown;


        public static ErrorCode fromStatus(int statusCode) {
            switch (statusCode) {
                case 200: {
                    return null;
                }
                case 400: {
                    return badRequest;
                }
                case 403: {
                    return authenticationFailure;
                }
                case 405: {
                    return invalidMethod;
                }
                case 410: {
                    return deviceTokenInactive;
                }
                case 413: {
                    return payloadTooLarge;
                }
                case 429: {
                    return tooManyRequestsForDeviceToken;
                }
                case 500: {
                    return internalServerError;
                }
                case 503: {
                    return serverShutdown;
                }
            }
            return internalServerError;
        }
    }

    public static class Builder {
        private static final String a = "api.sandbox.push.apple.com";
        private static final String b = "api.push.apple.com";
        private ApnsDelegate c;
        private KeyManagerFactory d;
        private Executor e;
        private String f = "api.push.apple.com";

        private Builder() {
        }

        public Builder withAppleDestination(boolean value) {
            this.f = value ? b : a;
            return this;
        }

        public Builder withCert(String certPath, String certPass) throws IOException {
            try (FileInputStream fileInputStream = new FileInputStream(certPath);){
                Builder builder = this.withCert(fileInputStream, certPass);
                return builder;
            }
        }

        public Builder withCert(InputStream is, String certPass) throws IOException {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(is, certPass.toCharArray());
                return this.withCertificateKeyStore(keyStore, certPass);
            }
            catch (Exception exception) {
                throw new IOException("Could not load key store", exception);
            }
        }

        public Builder withCertificateKeyStore(KeyStore keyStore, String keyStorePassword) throws IOException {
            try {
                this.d = KeyManagerFactory.getInstance("sunx509");
                this.d.init(keyStore, keyStorePassword.toCharArray());
                return this;
            }
            catch (Exception exception) {
                throw new IOException("Could not initialize key manager factory", exception);
            }
        }

        public Builder withDelegate(ApnsDelegate delegate) {
            this.c = delegate;
            return this;
        }

        public ApnsService build() throws IOException {
            return new ApnsService(this);
        }
    }
}

