/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.fcm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.LogManager;
import org.junit.Test;
import tigase.jaxmpp.core.client.exceptions.JaxmppException;
import tigase.push.fcm.FcmConnection;
import tigase.push.fcm.FcmProvider;

public class FcmConnectionTest {
    private final String deviceId = System.getProperty("deviceId");
    private final String senderId = System.getProperty("senderId");
    private final String serverKey = System.getProperty("serverKey");

    @Test
    public void testConnection() throws InterruptedException, IOException {
        if (this.serverKey == null || this.senderId == null) {
            return;
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=java.util.logging.ConsoleHandler\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST".getBytes()));
        FcmConnection conn = new FcmConnection(this.serverKey, this.senderId, true);
        conn.setProvider(new FcmProvider(){

            public void connected(FcmConnection conn) {
                System.out.println("Connection established " + conn);
                try {
                    conn.sendNotification("{\"to\":\"" + FcmConnectionTest.this.deviceId + "\",\"dry_run\":true, \"message_id\":\"" + UUID.randomUUID().toString() + "\"\"data\":{\"body\":\"Yellow or green?\"},\"priority\":10}");
                }
                catch (JaxmppException e) {
                    e.printStackTrace();
                }
            }

            public void disconnected(FcmConnection conn) {
                System.out.println("Connection broken " + conn);
            }

            public void unregisterDevice(String deviceId) {
                System.out.println("Device " + deviceId + " unregistered");
            }
        });
        conn.start();
        Thread.sleep(60000L);
    }
}

