/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.LogManager;
import org.junit.Test;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.apns.APNsBinaryApiProvider;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class APNSProviderTest {
    private final String deviceId = System.getProperty("deviceId");
    private final String certificatePath = System.getProperty("certPath");
    private final String certificatePassword = System.getProperty("certPass");

    @Test
    public void testProvider() throws NoSuchFieldException, IllegalAccessException, InterruptedException, IOException, TigaseStringprepException {
        if (this.certificatePath == null || this.certificatePassword == null) {
            return;
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=java.util.logging.ConsoleHandler\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST".getBytes()));
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        Field f = provider.getClass().getDeclaredField("certificatePath");
        f.setAccessible(true);
        f.set(provider, this.certificatePath);
        f = provider.getClass().getDeclaredField("certificatePassword");
        f.setAccessible(true);
        f.set(provider, this.certificatePassword);
        f = provider.getClass().getDeclaredField("fallbackToSandbox");
        f.setAccessible(true);
        f.set(provider, true);
        f = provider.getClass().getDeclaredField("apnsTopic");
        f.setAccessible(true);
        f.set(provider, "org.tigase.messenger.mobile");
        provider.beanConfigurationChanged(Arrays.asList("certificatePath"));
        Thread.sleep(3000L);
        for (int i = 0; i < 1; ++i) {
            PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)"andrzej.wojcik@tigase.org"), INotification.Priority.high, Long.valueOf(1L), JID.jidInstance((String)"int@muc.tigase.org"), "Some very important message " + UUID.randomUUID().toString(), "kobit");
            provider.pushNotification(this.deviceId, (INotification)plainNotification);
            Thread.sleep(1000L);
        }
        Thread.sleep(10000L);
    }
}

