/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractPushRepository<DS extends DataSource>
implements IPushRepository<DS> {
    private static final Charset a = Charset.forName("UTF-8");
    private static final char[] b = "0123456789ABCDEF".toCharArray();

    @Override
    public IPushSettings getNodeSettings(BareJID userJid, String provider, String deviceId) throws RepositoryException {
        return this.getNodeSettings(provider, deviceId).filter(iPushSettings -> iPushSettings.getOwenerJid().equals((Object)userJid)).findFirst().orElse(null);
    }

    protected String calculateNode(BareJID serviceJid, BareJID userJid) throws RepositoryException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(userJid.toString().toLowerCase().getBytes(a));
            messageDigest.update((byte)0);
            byte[] byArray = messageDigest.digest(serviceJid.toString().toLowerCase().getBytes(a));
            return this.toHex(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RepositoryException((Throwable)noSuchAlgorithmException);
        }
    }

    protected String toHex(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            int n = data[i] & 0xFF;
            stringBuilder.append(b[n >>> 4]);
            stringBuilder.append(b[n & 0xF]);
        }
        return stringBuilder.toString();
    }
}

