/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.Collections;
import java.util.List;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="register-device", parent=PushNotificationsComponent.class, active=true)
public class RegisterDevice
extends AbstractAdHocCommand {
    @Inject(nullAllowed=true)
    private List<IPushProvider> pushProviders;
    @Inject
    private IPushRepository repository;

    public String getName() {
        return "Register device";
    }

    public String getNode() {
        return "register-device";
    }

    public boolean isAllowedFor(JID jid) {
        return true;
    }

    public void setPushProviders(List<IPushProvider> pushProviders) {
        if (pushProviders == null) {
            pushProviders = Collections.emptyList();
        }
        this.pushProviders = pushProviders;
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("result", "Register device", "Use this form to register device for push notifications");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray2[i] = iPushProvider.getName();
            stringArray[i] = iPushProvider.getDescription();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextSingle((String)"device-token", (String)"", (String)"Device token"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = form.getAsString("device-token");
        if (string == null || string2 == null) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider and device token must not be empty");
        }
        if (!this.pushProviders.stream().filter(iPushProvider -> iPushProvider.getName().equals(string)).findAny().isPresent()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider");
        }
        try {
            IPushSettings iPushSettings = this.repository.getNodeSettings(request.getSender().getBareJID(), string, string2);
            if (iPushSettings == null) {
                iPushSettings = this.repository.registerDevice(request.getRecipient().getBareJID(), request.getSender().getBareJID(), string, string2);
            }
            Form form2 = new Form("result", "Device registered", "Use data from form to set notifications to push service");
            form2.addField(Field.fieldTextSingle((String)"node", (String)iPushSettings.getNode(), (String)"Node to publish notifications to"));
            response.completeSession();
            return form2;
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

