/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.repositories;

import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractIPushRepositoryTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, IPushRepository> {
    private static String[] devices = new String[]{"device-1", "device-2"};
    private static String[] nodes = new String[devices.length];
    private static BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"push.example.com");
    private static BareJID user2Jid = BareJID.bareJIDInstanceNS((String)("user2-" + UUID.randomUUID() + "@example.com"));
    private static BareJID userJid = BareJID.bareJIDInstanceNS((String)("user-" + UUID.randomUUID() + "@example.com"));
    protected IPushRepository repository;

    @Before
    public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
        this.repository = (IPushRepository)this.getDataSourceAware();
    }

    @After
    public void cleanUp() {
        this.repository = null;
    }

    @Test
    public void test01_testMissingNode() throws Exception {
        Assert.assertNull((Object)this.repository.getNodeSettings(serviceJid, "some-node"));
    }

    @Test
    public void test02_testDeviceRegistration1() throws Exception {
        IPushSettings settings = this.repository.registerDevice(serviceJid, userJid, "dummy", devices[0]);
        Assert.assertNotNull((Object)settings);
        Assert.assertNotNull((Object)settings.getNode());
        AbstractIPushRepositoryTest.nodes[0] = settings.getNode();
    }

    @Test
    public void test03_checkNode() throws Exception {
        IPushSettings settings = this.repository.getNodeSettings(serviceJid, nodes[0]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[0], (Object)settings.getNode());
        Assert.assertArrayEquals((Object[])new String[]{devices[0]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).toArray(String[]::new));
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
        settings = this.repository.getNodeSettings(userJid, "dummy", devices[0]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[0], (Object)settings.getNode());
        Assert.assertArrayEquals((Object[])new String[]{devices[0]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).toArray(String[]::new));
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
    }

    @Test
    public void test04_testDeviceRegistration2() throws Exception {
        IPushSettings settings = this.repository.registerDevice(serviceJid, userJid, "dummy", devices[1]);
        Assert.assertNotNull((Object)settings);
        Assert.assertNotNull((Object)settings.getNode());
        AbstractIPushRepositoryTest.nodes[1] = settings.getNode();
    }

    @Test
    public void test05_checkNode() throws Exception {
        IPushSettings settings = this.repository.getNodeSettings(serviceJid, nodes[1]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[1], (Object)settings.getNode());
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
        if (nodes[0].equals(nodes[1])) {
            Assert.assertArrayEquals((Object[])devices, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        } else {
            Assert.assertArrayEquals((Object[])new String[]{devices[1]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        }
        settings = this.repository.getNodeSettings(userJid, "dummy", devices[1]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[1], (Object)settings.getNode());
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
        if (nodes[0].equals(nodes[1])) {
            Assert.assertArrayEquals((Object[])devices, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        } else {
            Assert.assertArrayEquals((Object[])new String[]{devices[1]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        }
    }

    @Test
    public void test06_testNodeForDifferentUser() throws Exception {
        IPushSettings settings = this.repository.getNodeSettings(serviceJid, nodes[0]);
        Assert.assertNotNull((Object)settings);
        Assert.assertFalse((boolean)settings.isOwner(user2Jid));
    }

    @Test
    public void test07_testDeviceUnregisrationByDifferentUser() throws Exception {
        IPushSettings settings;
        try {
            settings = this.repository.unregisterDevice(serviceJid, user2Jid, "dummy", devices[0]);
            Assert.assertFalse((boolean)true);
        }
        catch (ComponentException ex) {
            Assert.assertEquals((Object)Authorization.ITEM_NOT_FOUND, (Object)ex.getErrorCondition());
        }
        settings = this.repository.getNodeSettings(serviceJid, nodes[1]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[1], (Object)settings.getNode());
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
        if (nodes[0].equals(nodes[1])) {
            Assert.assertArrayEquals((Object[])devices, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        } else {
            Assert.assertArrayEquals((Object[])new String[]{devices[1]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).sorted().toArray(String[]::new));
        }
    }

    @Test
    public void test08_testDeviceUnregiraton1() throws Exception {
        IPushSettings settings = this.repository.unregisterDevice(serviceJid, userJid, "dummy", devices[0]);
        Assert.assertNotNull((Object)settings);
    }

    @Test
    public void test09_checkNode() throws Exception {
        IPushSettings settings = this.repository.getNodeSettings(serviceJid, nodes[1]);
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((Object)nodes[1], (Object)settings.getNode());
        Assert.assertArrayEquals((Object[])new String[]{devices[1]}, (Object[])settings.getDevices().stream().map(device -> device.getDeviceId()).toArray(String[]::new));
        Assert.assertEquals((Object)userJid, (Object)settings.getOwenerJid());
    }

    @Test
    public void test10_testDeviceUnregiratonWihtoutServiceJidAndUserJid() throws Exception {
        IPushSettings settings = this.repository.getNodeSettings("dummy", devices[1]).findAny().orElse(null);
        Assert.assertNotNull((Object)settings);
        settings = this.repository.unregisterDevice(settings.getServiceJid(), settings.getOwenerJid(), "dummy", devices[1]);
        Assert.assertNotNull((Object)settings);
    }

    @Test
    public void test11_ensureNodeIsRemoved() throws Exception {
        Assert.assertNull((Object)this.repository.getNodeSettings(serviceJid, nodes[0]));
        Assert.assertNull((Object)this.repository.getNodeSettings(serviceJid, nodes[1]));
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return IPushRepository.class;
    }
}

