/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.modules;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.component.responses.AsyncCallback;
import tigase.push.PushNotificationHelper;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushSettings;
import tigase.push.modules.PublishNotificationModule;
import tigase.push.repositories.InMemoryPushRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.JID;

public class PublishNotificationModuleTest {
    private PublishNotificationModule module = new PublishNotificationModule();

    @Test
    public void test_getFeatures() {
        Assert.assertTrue((boolean)Arrays.asList(this.module.getFeatures()).contains("urn:xmpp:push:0"));
    }

    @Test
    public void test_criteria() throws Exception {
        Packet pushNotification = PushNotificationHelper.createPushNotification(JID.jidInstance((String)"push.example.com"), JID.jidInstance((String)"user@example.com"), "some-node", PushNotificationHelper.createNotification(10L, JID.jidInstance((String)"user2@example.com"), "Some body of a message"));
        Assert.assertTrue((boolean)this.module.getModuleCriteria().match(pushNotification.getElement()));
        Assert.assertFalse((boolean)this.module.getModuleCriteria().match(new Element("message")));
        Assert.assertFalse((boolean)this.module.getModuleCriteria().match(new Element("iq")));
        Assert.assertFalse((boolean)this.module.getModuleCriteria().match(new Element("presence")));
    }

    @Test
    public void test_process_success() throws Exception {
        JID serviceJid = JID.jidInstance((String)"push.example.com");
        JID userJid = JID.jidInstance((String)"user@example.com");
        String deviceId = UUID.randomUUID().toString();
        InMemoryPushRepository reposistory = new InMemoryPushRepository();
        IPushSettings pushSettings = reposistory.registerDevice(serviceJid.getBareJID(), userJid.getBareJID(), "dummy", deviceId);
        String node = pushSettings.getNode();
        Field f = PublishNotificationModule.class.getDeclaredField("repository");
        f.setAccessible(true);
        f.set(this.module, reposistory);
        final ArrayList packetQueue = new ArrayList();
        f = AbstractModule.class.getDeclaredField("writer");
        f.setAccessible(true);
        f.set(this.module, new PacketWriter(){

            public void write(Collection<Packet> packets) {
                packets.forEach(this::write);
            }

            public void write(Packet packet) {
                packetQueue.add(packet);
            }

            public void write(Packet packet, AsyncCallback callback) {
                this.write(packet);
            }
        });
        final ArrayList deviceQueue = new ArrayList();
        final ArrayList notificationQueue = new ArrayList();
        this.module.setPushProviders(Collections.singletonList(new IPushProvider(){

            public String getName() {
                return "dummy";
            }

            public String getDescription() {
                return "Dummy provider";
            }

            public void pushNotification(String deviceId, INotification notification) {
                deviceQueue.add(deviceId);
                notificationQueue.add(notification);
            }
        }));
        Packet pushNotification = PushNotificationHelper.createPushNotification(serviceJid, userJid, node, PushNotificationHelper.createNotification(10L, JID.jidInstance((String)"user2@example.com"), "Some body of a message"));
        this.module.process(pushNotification);
        Assert.assertEquals((long)1L, (long)deviceQueue.size());
        Assert.assertEquals((long)1L, (long)notificationQueue.size());
        Assert.assertEquals((long)1L, (long)packetQueue.size());
        Assert.assertEquals((Object)deviceId, deviceQueue.get(0));
        INotification notification = (INotification)notificationQueue.get(0);
        Assert.assertEquals((long)10L, (long)notification.getMessageCount());
        Assert.assertEquals((Object)JID.jidInstance((String)"user2@example.com"), (Object)notification.getLastMessageSender());
        Assert.assertEquals((Object)"Some body of a message", (Object)notification.getLastMessageBody());
        Assert.assertEquals((Object)StanzaType.result, (Object)((Packet)packetQueue.get(0)).getType());
        Assert.assertEquals((Object)"iq", (Object)((Packet)packetQueue.get(0)).getElemName());
        Assert.assertEquals((Object)userJid, (Object)((Packet)packetQueue.get(0)).getStanzaTo());
        Assert.assertEquals((Object)serviceJid, (Object)((Packet)packetQueue.get(0)).getStanzaFrom());
    }

    @Test
    public void test_process_failures() throws Exception {
        JID serviceJid = JID.jidInstance((String)"push.example.com");
        JID userJid = JID.jidInstance((String)"user@example.com");
        String deviceId = UUID.randomUUID().toString();
        InMemoryPushRepository reposistory = new InMemoryPushRepository();
        IPushSettings pushSettings = reposistory.registerDevice(serviceJid.getBareJID(), userJid.getBareJID(), "dummy", deviceId);
        String node = pushSettings.getNode();
        Field f = PublishNotificationModule.class.getDeclaredField("repository");
        f.setAccessible(true);
        f.set(this.module, reposistory);
        final ArrayList packetQueue = new ArrayList();
        f = AbstractModule.class.getDeclaredField("writer");
        f.setAccessible(true);
        f.set(this.module, new PacketWriter(){

            public void write(Collection<Packet> packets) {
                packets.forEach(this::write);
            }

            public void write(Packet packet) {
                packetQueue.add(packet);
            }

            public void write(Packet packet, AsyncCallback callback) {
                this.write(packet);
            }
        });
        final ArrayList deviceQueue = new ArrayList();
        final ArrayList notificationQueue = new ArrayList();
        this.module.setPushProviders(Collections.singletonList(new IPushProvider(){

            public String getName() {
                return "dummy";
            }

            public String getDescription() {
                return "Dummy provider";
            }

            public void pushNotification(String deviceId, INotification notification) {
                deviceQueue.add(deviceId);
                notificationQueue.add(notification);
            }
        }));
        Packet pushNotification = PushNotificationHelper.createPushNotification(serviceJid, userJid, node + "%%", PushNotificationHelper.createNotification(10L, JID.jidInstance((String)"user2@example.com"), "Some body of a message"));
        try {
            this.module.process(pushNotification);
            Assert.assertFalse((boolean)true);
        }
        catch (ComponentException ex) {
            Assert.assertEquals((Object)Authorization.ITEM_NOT_FOUND, (Object)ex.getErrorCondition());
        }
        pushNotification = PushNotificationHelper.createPushNotification(serviceJid, JID.jidInstance((String)"not-owner@example.com"), node, PushNotificationHelper.createNotification(10L, JID.jidInstance((String)"user2@example.com"), "Some body of a message"));
        try {
            this.module.process(pushNotification);
            Assert.assertFalse((boolean)true);
        }
        catch (ComponentException ex) {
            Assert.assertEquals((Object)Authorization.FORBIDDEN, (Object)ex.getErrorCondition());
        }
        pushNotification = PushNotificationHelper.createPushNotification(serviceJid, JID.jidInstance((String)"not-owner@example.com"), node, new Element("dummy"));
        try {
            this.module.process(pushNotification);
            Assert.assertFalse((boolean)true);
        }
        catch (ComponentException ex) {
            Assert.assertEquals((Object)Authorization.BAD_REQUEST, (Object)ex.getErrorCondition());
        }
    }
}

