/*
 * Decompiled with CFR 0.152.
 */
package tigase.push;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import tigase.Assert;
import tigase.db.DataSource;
import tigase.db.NonAuthUserRepository;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.core.Kernel;
import tigase.push.PushNotificationHelper;
import tigase.push.PushNotifications;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PushNotificationsTest
extends ProcessorTestCase {
    private MsgRepository msgRepository;
    private PushNotifications pushNotifications;
    private JID pushServiceJid = JID.jidInstanceNS((String)"push.example.com");
    private JID recipientJid;
    private JID senderJid;

    @Before
    public void setUp() throws Exception {
        this.recipientJid = JID.jidInstanceNS((String)("recipient-" + UUID.randomUUID() + "@example.com/res-1"));
        this.senderJid = JID.jidInstanceNS((String)("sender-" + UUID.randomUUID() + "@example.com/res-1"));
        super.setUp();
        this.pushNotifications = (PushNotifications)this.getInstance(PushNotifications.class);
        this.msgRepository = (MsgRepository)this.getInstance(MsgRepository.class);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test_initialState() throws Exception {
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void test_enable() throws Exception {
        Element iqEl = new Element("iq", new Element[]{new Element("enable", new String[]{"xmlns", "jid", "node"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node"})}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNotNull((Object)((UserRepository)this.getInstance(UserRepository.class)).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Method m = PushNotifications.class.getDeclaredMethod("getPushServices", BareJID.class);
        m.setAccessible(true);
        Map settings = (Map)m.invoke((Object)this.pushNotifications, this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals((Element)new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)((Element)settings.get(this.pushServiceJid + "/push-node")));
        m = PushNotifications.class.getDeclaredMethod("getPushServices", XMPPResourceConnection.class);
        m.setAccessible(true);
        settings = (Map)m.invoke((Object)this.pushNotifications, session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)1L, (long)settings.size());
        Assert.assertElementEquals((Element)new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}), (Element)((Element)settings.get(this.pushServiceJid + "/push-node")));
    }

    @Test
    public void test_disable() throws Exception {
        Element iqEl = new Element("iq", new Element[]{new Element("disable", new String[]{"xmlns", "jid", "node"}, new String[]{"urn:xmpp:push:0", this.pushServiceJid.toString(), "push-node"})}, new String[]{"type", "id"}, new String[]{"set", UUID.randomUUID().toString()});
        XMPPResourceConnection session = this.getSession(JID.jidInstanceNS((String)("c2s@example.com/" + UUID.randomUUID().toString())), this.recipientJid);
        ((UserRepository)this.getInstance(UserRepository.class)).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        Packet iq = Packet.packetInstance((Element)iqEl);
        iq.setPacketFrom(session.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.process(iq, session, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        org.junit.Assert.assertEquals((String)("wrong result = " + result), (Object)StanzaType.result, (Object)result.getType());
        org.junit.Assert.assertNull((Object)((UserRepository)this.getInstance(UserRepository.class)).getData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node"));
        Method m = PushNotifications.class.getDeclaredMethod("getPushServices", BareJID.class);
        m.setAccessible(true);
        Map settings = (Map)m.invoke((Object)this.pushNotifications, this.recipientJid.getBareJID());
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
        m = PushNotifications.class.getDeclaredMethod("getPushServices", XMPPResourceConnection.class);
        m.setAccessible(true);
        settings = (Map)m.invoke((Object)this.pushNotifications, session);
        org.junit.Assert.assertNotNull((Object)settings);
        org.junit.Assert.assertEquals((long)0L, (long)settings.size());
    }

    @Test
    public void test_notificationGeneration() throws Exception {
        ((UserRepository)this.getInstance(UserRepository.class)).setData(this.recipientJid.getBareJID(), "urn:xmpp:push:0", this.pushServiceJid + "/push-node", new Element("settings", new String[]{"jid", "node"}, new String[]{this.pushServiceJid.toString(), "push-node"}).toString());
        String msgBody = "Message body " + UUID.randomUUID().toString();
        Element msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        Packet packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        ArrayDeque results = new ArrayDeque();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        Packet expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createNotification(1L, this.senderJid, msgBody));
        Assert.assertElementEquals((Element)expNotification.getElement(), (Element)((Packet)results.poll()).getElement());
        msgBody = "Message body " + UUID.randomUUID().toString();
        msg = new Element("message", new Element[]{new Element("body", msgBody)}, new String[]{"xmlns"}, new String[]{"jabber:client"});
        packet = Packet.packetInstance((Element)msg, (JID)this.senderJid, (JID)this.recipientJid);
        this.msgRepository.storeMessage(this.senderJid, this.recipientJid, new Date(), packet.getElement(), null);
        results = new ArrayDeque();
        this.pushNotifications.notifyNewOfflineMessage(packet, null, results, new HashMap());
        org.junit.Assert.assertEquals((long)1L, (long)results.size());
        expNotification = PushNotificationHelper.createPushNotification(this.pushServiceJid, this.recipientJid, "push-node", PushNotificationHelper.createNotification(2L, this.senderJid, msgBody));
        Assert.assertElementEquals((Element)expNotification.getElement(), (Element)((Packet)results.poll()).getElement());
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("msgRepository").asClass(MsgRepositoryIfcImpl.class).exec();
        kernel.registerBean(PushNotifications.class).setActive(true).exec();
    }

    public static class MsgRepositoryIfcImpl
    extends MsgRepository {
        private final Queue<Packet> stored = new ArrayDeque<Packet>();

        public Element getMessageExpired(long time, boolean delete) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
            LinkedList<Element> res = new LinkedList<Element>();
            for (Packet pac : this.stored) {
                res.add(pac.getElement());
            }
            return res;
        }

        public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
            return this.stored.offer(Packet.packetInstance((Element)msg, (JID)from, (JID)to));
        }

        public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
            return this.stored.stream().collect(Collectors.groupingBy(packet -> {
                switch (packet.getElemName()) {
                    case "message": {
                        return MsgRepository.MSG_TYPES.message;
                    }
                    case "presence": {
                        return MsgRepository.MSG_TYPES.presence;
                    }
                }
                return MsgRepository.MSG_TYPES.none;
            }, Collectors.counting()));
        }

        public List<Element> getMessagesList(JID to) throws UserNotFoundException {
            return null;
        }

        public int deleteMessagesToJID(List db_ids, XMPPResourceConnection session) throws UserNotFoundException {
            return 0;
        }

        public Queue<Element> loadMessagesToJID(List db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
            return null;
        }

        public Queue<Packet> getStored() {
            return this.stored;
        }

        public void setDataSource(DataSource dataSource) {
        }

        protected void loadExpiredQueue(int max) {
        }

        protected void loadExpiredQueue(Date expired) {
        }

        protected void deleteMessage(Object db_id) {
        }
    }
}

