/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.modules.mam.ExtendedQueryImpl;
import tigase.pubsub.repository.IExtendedPubSubDAO;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.stateless.NodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.util.MAMUtil;
import tigase.xmpp.mam.util.Range;
import tigase.xmpp.rsm.RSM;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="pubsub", name="Tigase PubSub Component")
public class PubSubDAOJDBC
extends PubSubDAO<Long, DataRepository, ExtendedQueryImpl>
implements RepositoryVersionAware,
IExtendedPubSubDAO<Long, DataRepository, ExtendedQueryImpl> {
    private static final String CREATE_NODE_QUERY = "{ call TigPubSubCreateNode(?, ?, ?, ?, ?, ?, ?, ?, ?) }";
    private static final String REMOVE_NODE_QUERY = "{ call TigPubSubRemoveNode(?) }";
    private static final String CREATE_SERVICE_QUERY = "{ call TigPubSubCreateService(?, ?, ?) }";
    private static final String REMOVE_SERVICE_QUERY = "{ call TigPubSubRemoveService(?) }";
    private static final String GET_SERVICES_QUERY = "{ call TigPubSubGetServices(?,?) }";
    private static final String GET_NODE_ID_QUERY = "{ call TigPubSubGetNodeId(?, ?) }";
    private static final String GET_NODE_META_QUERY = "{ call TigPubSubGetNodeMeta(?, ?) }";
    private static final String GET_ITEM_QUERY = "{ call TigPubSubGetItem(?, ?) }";
    private static final String WRITE_ITEM_QUERY = "{ call TigPubSubWriteItem(?, ?, ?, ?, ?, ?) }";
    private static final String DELETE_ITEM_QUERY = "{ call TigPubSubDeleteItem(?, ?) }";
    private static final String GET_NODE_ITEM_IDS_QUERY = "{ call TigPubSubGetNodeItemsIds(?,?) }";
    private static final String GET_NODE_ITEM_IDS_SINCE_QUERY = "{ call TigPubSubGetNodeItemsIdsSince(?,?,?) }";
    private static final String GET_NODE_ITEMS_META_QUERY = "{ call TigPubSubGetNodeItemsMeta(?) }";
    private static final String COUNT_NODES_QUERY = "{ call TigPubSubCountNodes(?) }";
    private static final String GET_ALL_NODES_QUERY = "{ call TigPubSubGetAllNodes(?) }";
    private static final String GET_ROOT_NODES_QUERY = "{ call TigPubSubGetRootNodes(?) }";
    private static final String GET_CHILD_NODES_QUERY = "{ call TigPubSubGetChildNodes(?,?) }";
    private static final String SET_NODE_CONFIGURATION_QUERY = "{ call TigPubSubSetNodeConfiguration(?, ?, ?) }";
    private static final String SET_NODE_AFFILIATION_QUERY = "{ call TigPubSubSetNodeAffiliation(?, ?, ?) }";
    private static final String GET_NODE_AFFILIATIONS_QUERY = "{ call TigPubSubGetNodeAffiliations(?) }";
    private static final String GET_NODE_SUBSCRIPTIONS_QUERY = "{ call TigPubSubGetNodeSubscriptions(?) }";
    private static final String SET_NODE_SUBSCRIPTION_QUERY = "{ call TigPubSubSetNodeSubscription(?, ?, ?, ?) }";
    private static final String DELETE_NODE_SUBSCRIPTIONS_QUERY = "{ call TigPubSubDeleteNodeSubscription(?, ?) }";
    private static final String GET_USER_AFFILIATIONS_QUERY = "{ call TigPubSubGetUserAffiliations(?, ?) }";
    private static final String GET_USER_SUBSCRIPTIONS_QUERY = "{ call TigPubSubGetUserSubscriptions(?, ?) }";
    private static final String COUNT_NODES_ITEMS_QUERY = "{ call TigPubSubQueryItemsCount(?,?,?,?) }";
    private static final String GET_NODES_ITEMS_QUERY = "{ call TigPubSubQueryItems(?,?,?,?,?,?) }";
    private static final String GET_NODES_ITEMS_POSITION_QUERY = "{ call TigPubSubQueryItemPosition(?,?,?,?,?,?) }";
    private DataRepository data_repo;
    @ConfigField(desc="Add entry to MAM repository", alias="mam-add-item-query")
    private String mamAddItem = "{ call TigPubSubMamAddItem(?,?,?,?,?) }";
    @ConfigField(desc="Find item position in result set from repository", alias="mam-query-item-position-query")
    private String mamQueryItemPosition = "{ call TigPubSubMamQueryItemPosition(?,?,?,?) }";
    @ConfigField(desc="Retrieve item from repository", alias="mam-query-item-query")
    private String mamQueryItem = "{ call TigPubSubMamQueryItem(?,?) }";
    @ConfigField(desc="Retrieve items from repository", alias="mam-query-items-query")
    private String mamQueryItems = "{ call TigPubSubMamQueryItems(?,?,?,?,?) }";
    @ConfigField(desc="Count number of items from repository", alias="mam-query-items-count-query")
    private String mamQueryItemsCount = "{ call TigPubSubMamQueryItemsCount(?,?,?) }";
    @ConfigField(desc="Update entry in MAM repository", alias="mam-update-item-query")
    private String mamUpdateItem = "{ call TigPubSubMamUpdateItem(?,?,?) }";
    private LinkedBlockingDeque<HashCode> pool_hashCodes = new LinkedBlockingDeque();

    /*
     * Exception decompiling
     */
    @Override
    public Long createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, Long collectionId, boolean autocreateService) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createService(BareJID serviceJID, boolean isPublic) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "creating service: serviceJid: {0}, component: {1}, public: {2}", new Object[]{serviceJID, serviceJID.getDomain(), isPublic});
        }
        HashCode hash = null;
        try {
            PreparedStatement createServiceStmt;
            hash = this.takeDao();
            PreparedStatement preparedStatement = createServiceStmt = this.data_repo.getPreparedStatement(hash.hashCode(), CREATE_SERVICE_QUERY);
            synchronized (preparedStatement) {
                createServiceStmt.setString(1, serviceJID.toString());
                createServiceStmt.setString(2, serviceJID.getDomain());
                createServiceStmt.setInt(3, isPublic ? 1 : 0);
                createServiceStmt.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item removing error", (Throwable)e);
        }
        finally {
            if (hash != null) {
                this.offerDao(hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MAMRepository.Item getMAMItem(BareJID ownerJid, Long nodeId, String stableId) throws RepositoryException {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(ownerJid, this.mamQueryItem);
            synchronized (preparedStatement) {
                ResultSet rs;
                block7: {
                    PubSubDAO.MAMItem mAMItem;
                    rs = null;
                    try {
                        st.setLong(1, nodeId);
                        st.setString(2, stableId);
                        rs = st.executeQuery();
                        if (!rs.next()) break block7;
                        String itemUuid = rs.getString(1);
                        Timestamp ts = this.data_repo.getTimestamp(rs, 2);
                        Element itemEl = this.itemDataToElement(rs.getString(3));
                        mAMItem = new PubSubDAO.MAMItem(itemUuid, ts, itemEl);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return mAMItem;
                }
                MAMRepository.Item item = null;
                this.data_repo.release(null, rs);
                return item;
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Failed to get item from MAM", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMAMItem(BareJID ownerJid, Long nodeId, String stableId, Element message) throws RepositoryException {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(ownerJid, this.mamUpdateItem);
            synchronized (preparedStatement) {
                st.setLong(1, nodeId);
                st.setString(2, stableId);
                st.setString(3, message.toString());
                st.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Failed to update item in MAM", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BareJID> getServices(BareJID domain, Boolean isPublic) throws RepositoryException {
        HashCode hash = null;
        try {
            PreparedStatement getServicesStmt;
            hash = this.takeDao();
            PreparedStatement preparedStatement = getServicesStmt = this.data_repo.getPreparedStatement(hash.hashCode(), GET_SERVICES_QUERY);
            synchronized (preparedStatement) {
                ArrayList<BareJID> arrayList;
                block17: {
                    try {
                        getServicesStmt.setString(1, domain.toString());
                        if (isPublic != null) {
                            getServicesStmt.setInt(2, isPublic != false ? 1 : 0);
                        } else {
                            getServicesStmt.setNull(2, 4);
                        }
                        ResultSet rs = getServicesStmt.executeQuery();
                        ArrayList<BareJID> results = new ArrayList<BareJID>();
                        while (rs.next()) {
                            results.add(BareJID.bareJIDInstanceNS((String)rs.getString(1)));
                        }
                        arrayList = results;
                        if (hash == null) break block17;
                        this.offerDao(hash);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (hash != null) {
                                this.offerDao(hash);
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new RepositoryException("Item removing error", (Throwable)e);
                        }
                    }
                }
                return arrayList;
            }
        }
        finally {
            if (hash != null) {
                this.offerDao(hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "deleting Item: serviceJid: {0}, nodeId: {1}, id: {2}", new Object[]{serviceJid, nodeId, id});
        }
        HashCode hash = null;
        try {
            PreparedStatement delete_item_sp;
            hash = this.takeDao();
            PreparedStatement preparedStatement = delete_item_sp = this.data_repo.getPreparedStatement(hash.hashCode(), DELETE_ITEM_QUERY);
            synchronized (preparedStatement) {
                delete_item_sp.setLong(1, nodeId);
                delete_item_sp.setString(2, id);
                delete_item_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item removing error", (Throwable)e);
        }
        finally {
            if (hash != null) {
                this.offerDao(hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "deleting Node: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        HashCode hash = null;
        try {
            PreparedStatement remove_node_sp;
            hash = this.takeDao();
            PreparedStatement preparedStatement = remove_node_sp = this.data_repo.getPreparedStatement(hash.hashCode(), REMOVE_NODE_QUERY);
            synchronized (preparedStatement) {
                remove_node_sp.setLong(1, nodeId);
                remove_node_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node deleting error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "get all nodes list: serviceJid: {0}", new Object[]{serviceJid});
        }
        HashCode hash = null;
        try {
            PreparedStatement get_all_nodes_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = get_all_nodes_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_ALL_NODES_QUERY);
            synchronized (preparedStatement) {
                String[] stringArray;
                try {
                    get_all_nodes_sp.setString(1, serviceJid.toString());
                    rs = get_all_nodes_sp.executeQuery();
                    ArrayList<String> names = new ArrayList<String>();
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                    stringArray = names.toArray(new String[0]);
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Nodes list getting error", (Throwable)e);
                    }
                }
                return stringArray;
            }
        }
        finally {
            this.offerDao(hash);
        }
    }

    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNodesList(serviceJid, nodeName);
    }

    /*
     * Exception decompiling
     */
    @Override
    public IItems.IItem getItem(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, Long nodeId, CollectionItemsOrdering order) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getting items IDs: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        if (null != nodeId) {
            HashCode hash = null;
            try {
                PreparedStatement get_node_items_ids_sp;
                ResultSet rs = null;
                hash = this.takeDao();
                PreparedStatement preparedStatement = get_node_items_ids_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_NODE_ITEM_IDS_QUERY);
                synchronized (preparedStatement) {
                    String[] stringArray;
                    try {
                        get_node_items_ids_sp.setLong(1, nodeId);
                        get_node_items_ids_sp.setInt(2, order.value());
                        rs = get_node_items_ids_sp.executeQuery();
                        ArrayList<String> ids = new ArrayList<String>();
                        while (rs.next()) {
                            ids.add(rs.getString(1));
                        }
                        stringArray = ids.toArray(new String[ids.size()]);
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.release(null, rs);
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new RepositoryException("Items list reading error", (Throwable)e);
                        }
                    }
                    return stringArray;
                }
            }
            finally {
                this.offerDao(hash);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIdsSince(BareJID serviceJid, Long nodeId, CollectionItemsOrdering order, Date since) throws RepositoryException {
        PreparedStatement get_node_items_ids_since_sp;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting items since: serviceJid: {0}, nodeId: {1}, since: {2}", new Object[]{serviceJid, nodeId, since});
        }
        HashCode hash = null;
        ResultSet rs = null;
        Timestamp sinceTs = new Timestamp(since.getTime());
        hash = this.takeDao();
        PreparedStatement preparedStatement = get_node_items_ids_since_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_NODE_ITEM_IDS_SINCE_QUERY);
        synchronized (preparedStatement) {
            String[] stringArray;
            try {
                get_node_items_ids_since_sp.setLong(1, nodeId);
                get_node_items_ids_since_sp.setInt(2, order.value());
                this.data_repo.setTimestamp(get_node_items_ids_since_sp, 3, sinceTs);
                rs = get_node_items_ids_since_sp.executeQuery();
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                stringArray = ids.toArray(new String[ids.size()]);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    this.offerDao(hash);
                    throw throwable2;
                }
            }
            this.offerDao(hash);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.IItem> getItems(BareJID serviceJid, List<Long> nodesIds, Date afterDate, Date beforeDate, RSM rsm, CollectionItemsOrdering ordering) throws RepositoryException {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodesIds.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(nodesIds.get(i));
        }
        String ids = sb.toString();
        Integer after = null;
        Integer before = null;
        try {
            int i;
            ResultSet rs;
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(ids.hashCode(), COUNT_NODES_ITEMS_QUERY);
            synchronized (preparedStatement) {
                rs = null;
                try {
                    i = 1;
                    st.setString(i++, ids);
                    this.data_repo.setTimestamp(st, i++, afterDate == null ? null : new Timestamp(afterDate.getTime()));
                    this.data_repo.setTimestamp(st, i++, beforeDate == null ? null : new Timestamp(beforeDate.getTime()));
                    st.setInt(i++, ordering.value());
                    rs = st.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
            if (rsm.getAfter() != null) {
                preparedStatement = st = this.data_repo.getPreparedStatement(ids.hashCode(), GET_NODES_ITEMS_POSITION_QUERY);
                synchronized (preparedStatement) {
                    rs = null;
                    try {
                        i = 1;
                        st.setString(i++, ids);
                        this.data_repo.setTimestamp(st, i++, afterDate == null ? null : new Timestamp(afterDate.getTime()));
                        this.data_repo.setTimestamp(st, i++, beforeDate == null ? null : new Timestamp(beforeDate.getTime()));
                        st.setInt(i++, ordering.value());
                        st.setLong(i++, IItemsItem.getNodeIdFromRsmId(rsm.getAfter()));
                        st.setString(i++, IItemsItem.getItemIdFromRsmId(rsm.getAfter()));
                        rs = st.executeQuery();
                        if (rs.next()) {
                            after = rs.getInt(1);
                        }
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                }
            }
            if (rsm.getBefore() != null) {
                preparedStatement = st = this.data_repo.getPreparedStatement(ids.hashCode(), GET_NODES_ITEMS_POSITION_QUERY);
                synchronized (preparedStatement) {
                    rs = null;
                    try {
                        i = 1;
                        st.setString(i++, ids);
                        this.data_repo.setTimestamp(st, i++, afterDate == null ? null : new Timestamp(afterDate.getTime()));
                        this.data_repo.setTimestamp(st, i++, beforeDate == null ? null : new Timestamp(beforeDate.getTime()));
                        st.setInt(i++, ordering.value());
                        st.setLong(i++, IItemsItem.getNodeIdFromRsmId(rsm.getBefore()));
                        st.setString(i++, IItemsItem.getItemIdFromRsmId(rsm.getBefore()));
                        rs = st.executeQuery();
                        if (rs.next()) {
                            before = rs.getInt(1);
                        }
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                }
            }
            PubSubDAOJDBC.calculateOffsetAndPosition(rsm, count, before, after);
            st = this.data_repo.getPreparedStatement(ids.hashCode(), GET_NODES_ITEMS_QUERY);
            ArrayList<IItems.IItem> results = new ArrayList<IItems.IItem>();
            PreparedStatement preparedStatement2 = st;
            synchronized (preparedStatement2) {
                ResultSet rs2 = null;
                try {
                    int i2 = 1;
                    st.setString(i2++, ids);
                    this.data_repo.setTimestamp(st, i2++, afterDate == null ? null : new Timestamp(afterDate.getTime()));
                    this.data_repo.setTimestamp(st, i2++, beforeDate == null ? null : new Timestamp(beforeDate.getTime()));
                    st.setInt(i2++, ordering.value());
                    st.setInt(i2++, rsm.getMax());
                    st.setInt(i2++, rsm.getIndex());
                    rs2 = st.executeQuery();
                    while (rs2.next()) {
                        String node = rs2.getString(1);
                        long nodeId = rs2.getLong(2);
                        String itemId = rs2.getString(3);
                        String itemUuid = rs2.getString(4);
                        Element itemEl = this.itemDataToElement(rs2.getString(5));
                        results.add(new IItemsItem(node, nodeId, itemId, itemUuid, itemEl));
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs2);
                    throw throwable;
                }
                this.data_repo.release(null, rs2);
            }
            if (results.size() > 0) {
                rsm.setLast(((IItemsItem)results.get(results.size() - 1)).getRsmId());
                rsm.setFirst(((IItemsItem)results.get(0)).getRsmId());
            }
            return results;
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Cound not retrieve items", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, Long nodeId, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting items meta: serviceJid: {0}, nodeId: {1}, nodeName: {2}", new Object[]{serviceJid, nodeId, nodeName});
        }
        HashCode hash = null;
        try {
            PreparedStatement get_node_items_meta_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = get_node_items_meta_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_NODE_ITEMS_META_QUERY);
            synchronized (preparedStatement) {
                ArrayList<IItems.ItemMeta> arrayList;
                try {
                    get_node_items_meta_sp.setLong(1, nodeId);
                    rs = get_node_items_meta_sp.executeQuery();
                    ArrayList<IItems.ItemMeta> results = new ArrayList<IItems.ItemMeta>();
                    while (rs.next()) {
                        String id = rs.getString(1);
                        Timestamp creationDate = this.data_repo.getTimestamp(rs, 2);
                        Timestamp updateDate = this.data_repo.getTimestamp(rs, 3);
                        String uuid = rs.getString(4);
                        results.add(new IItems.ItemMeta(nodeName, id, creationDate, updateDate, uuid));
                    }
                    arrayList = results;
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", (Throwable)e);
                    }
                }
                return arrayList;
            }
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, UsersAffiliation> getNodeAffiliations(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node affiliation: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        HashCode hash = null;
        try {
            PreparedStatement get_node_affiliations_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = get_node_affiliations_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_NODE_AFFILIATIONS_QUERY);
            synchronized (preparedStatement) {
                HashMap<BareJID, UsersAffiliation> hashMap;
                try {
                    get_node_affiliations_sp.setLong(1, nodeId);
                    rs = get_node_affiliations_sp.executeQuery();
                    HashMap<BareJID, UsersAffiliation> data = new HashMap<BareJID, UsersAffiliation>();
                    while (rs.next()) {
                        BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                        Affiliation affil = Affiliation.valueOf(rs.getString(2));
                        data.put(jid, new UsersAffiliation(jid, affil));
                    }
                    hashMap = data;
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Node subscribers reading error", (Throwable)e);
                    }
                }
                return hashMap;
            }
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * Exception decompiling
     */
    private Long getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public NodeMeta<Long> getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        PreparedStatement get_child_nodes_sp;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting nodes list: serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        HashCode hash = null;
        ResultSet rs = null;
        hash = this.takeDao();
        if (nodeName == null) {
            PreparedStatement get_root_nodes_sp;
            PreparedStatement preparedStatement = get_root_nodes_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_ROOT_NODES_QUERY);
            synchronized (preparedStatement) {
                String[] stringArray;
                try {
                    get_root_nodes_sp.setString(1, serviceJid.toString());
                    rs = get_root_nodes_sp.executeQuery();
                    ArrayList<String> names = new ArrayList<String>();
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                    stringArray = names.toArray(new String[0]);
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
                return stringArray;
            }
        }
        PreparedStatement preparedStatement = get_child_nodes_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_CHILD_NODES_QUERY);
        synchronized (preparedStatement) {
            String[] stringArray;
            try {
                get_child_nodes_sp.setString(1, serviceJid.toString());
                get_child_nodes_sp.setString(2, nodeName);
                rs = get_child_nodes_sp.executeQuery();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                stringArray = names.toArray(new String[0]);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Nodes list getting error", (Throwable)e);
                }
            }
            return stringArray;
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getNodesCount(BareJID serviceJid) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, UsersSubscription> getNodeSubscriptions(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node subscriptions: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        HashCode hash = null;
        try {
            PreparedStatement get_node_subscriptions_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = get_node_subscriptions_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_NODE_SUBSCRIPTIONS_QUERY);
            synchronized (preparedStatement) {
                HashMap<BareJID, UsersSubscription> hashMap;
                try {
                    get_node_subscriptions_sp.setLong(1, nodeId);
                    rs = get_node_subscriptions_sp.executeQuery();
                    HashMap<BareJID, UsersSubscription> data = new HashMap<BareJID, UsersSubscription>();
                    while (rs.next()) {
                        BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                        Subscription subscr = Subscription.valueOf(rs.getString(2));
                        String subscrId = rs.getString(3);
                        data.put(jid, new UsersSubscription(jid, subscrId, subscr));
                    }
                    hashMap = data;
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Node subscribers reading error", (Throwable)e);
                    }
                }
                return hashMap;
            }
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting user affiliation: serviceJid: {0}, jid: {1}", new Object[]{serviceJid, jid});
        }
        HashCode hash = null;
        try {
            ResultSet rs = null;
            HashMap<String, UsersAffiliation> result = new HashMap<String, UsersAffiliation>();
            hash = this.takeDao();
            PreparedStatement get_user_affiliations_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_USER_AFFILIATIONS_QUERY);
            Object object = get_user_affiliations_sp;
            synchronized (object) {
                try {
                    get_user_affiliations_sp.setString(1, serviceJid.toString());
                    get_user_affiliations_sp.setString(2, jid.toString());
                    rs = get_user_affiliations_sp.executeQuery();
                    while (rs.next()) {
                        String nodeName = rs.getString(1);
                        Affiliation affil = Affiliation.valueOf(rs.getString(2));
                        result.put(nodeName, new UsersAffiliation(jid, affil));
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
            object = result;
            this.offerDao(hash);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("User affiliations reading error", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.offerDao(hash);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting user subs: serviceJid: {0}, jid: {1}", new Object[]{serviceJid, jid});
        }
        HashCode hash = null;
        try {
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement get_user_subscriptions_sp = this.data_repo.getPreparedStatement(hash.hashCode(), GET_USER_SUBSCRIPTIONS_QUERY);
            HashMap<String, UsersSubscription> result = new HashMap<String, UsersSubscription>();
            Object object = get_user_subscriptions_sp;
            synchronized (object) {
                try {
                    get_user_subscriptions_sp.setString(1, serviceJid.toString());
                    get_user_subscriptions_sp.setString(2, jid.toString());
                    rs = get_user_subscriptions_sp.executeQuery();
                    while (rs.next()) {
                        String nodeName = rs.getString(1);
                        Subscription subscr = Subscription.valueOf(rs.getString(2));
                        String subscrId = rs.getString(3);
                        result.put(nodeName, new UsersSubscription(jid, subscrId, subscr));
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
            object = result;
            return object;
        }
        catch (SQLException e) {
            throw new RepositoryException("User affiliations reading error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMAMItem(BareJID serviceJid, Long nodeId, String uuid, Element message, Date timestamp, String itemId) throws RepositoryException {
        HashCode hash = null;
        try {
            hash = this.takeDao();
            PreparedStatement write_item_sp = this.data_repo.getPreparedStatement(hash.hashCode(), this.mamAddItem);
            ResultSet rs = null;
            PreparedStatement preparedStatement = write_item_sp;
            synchronized (preparedStatement) {
                try {
                    write_item_sp.setLong(1, nodeId);
                    write_item_sp.setString(2, uuid);
                    this.data_repo.setTimestamp(write_item_sp, 3, new Timestamp(timestamp.getTime()));
                    write_item_sp.setString(4, message.toString());
                    write_item_sp.setString(5, itemId);
                    write_item_sp.execute();
                }
                finally {
                    this.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item writing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    @Override
    public ExtendedQueryImpl newQuery(BareJID serviceJid) {
        return new ExtendedQueryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryItems(ExtendedQueryImpl query, Long nodeId, MAMRepository.ItemHandler<ExtendedQueryImpl, MAMRepository.Item> itemHandler) throws RepositoryException, ComponentException {
        block13: {
            try {
                PreparedStatement st;
                if (!query.getIds().isEmpty()) {
                    ArrayDeque<PubSubDAO.MAMItem> items = new ArrayDeque<PubSubDAO.MAMItem>();
                    for (String string : query.getIds()) {
                        PubSubDAO.MAMItem item = this.getMAMItem(query, nodeId, string);
                        if (item == null) {
                            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Item with ID '" + string + "' does not exist.");
                        }
                        items.add(item);
                    }
                    for (MAMRepository.Item item : items) {
                        itemHandler.itemFound((Query)query, item);
                    }
                    break block13;
                }
                Integer count = this.countMAMItems(query, nodeId);
                if (count == null) {
                    count = 0;
                }
                Range range = MAMUtil.rangeFromPositions((Integer)this.getMAMItemPosition(query, nodeId, query.getAfterId()), (Integer)this.getMAMItemPosition(query, nodeId, query.getBeforeId()));
                Integer n = this.getMAMItemPosition(query, nodeId, query.getRsm().getAfter());
                Integer before = this.getMAMItemPosition(query, nodeId, query.getRsm().getBefore());
                MAMUtil.calculateOffsetAndPosition((RSM)query.getRsm(), (int)count, (Integer)before, (Integer)n, (Range)range);
                int limit = Math.min(range.size(), query.getRsm().getMax());
                if (limit <= 0) break block13;
                PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamQueryItems);
                synchronized (preparedStatement) {
                    ResultSet rs = null;
                    try {
                        int i = this.setStatementParamsForMAM(st, query, nodeId);
                        st.setInt(i++, limit);
                        st.setInt(i++, range.getLowerBound() + query.getRsm().getIndex());
                        rs = st.executeQuery();
                        while (rs.next()) {
                            String itemUuid = rs.getString(1);
                            Timestamp ts = this.data_repo.getTimestamp(rs, 2);
                            Element itemEl = this.itemDataToElement(rs.getString(3));
                            itemHandler.itemFound((Query)query, (MAMRepository.Item)new PubSubDAO.MAMItem(itemUuid, ts, itemEl));
                        }
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                }
            }
            catch (SQLException ex) {
                throw new TigaseDBException("Cound not retrieve items", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PubSubDAO.MAMItem getMAMItem(ExtendedQueryImpl query, Long nodeId, String stableId) throws SQLException {
        PreparedStatement st;
        PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamQueryItem);
        synchronized (preparedStatement) {
            ResultSet rs;
            block5: {
                PubSubDAO.MAMItem mAMItem;
                rs = null;
                try {
                    st.setLong(1, nodeId);
                    st.setString(2, stableId);
                    rs = st.executeQuery();
                    if (!rs.next()) break block5;
                    String itemUuid = rs.getString(1);
                    Timestamp ts = this.data_repo.getTimestamp(rs, 2);
                    Element itemEl = this.itemDataToElement(rs.getString(3));
                    mAMItem = new PubSubDAO.MAMItem(itemUuid, ts, itemEl);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
                return mAMItem;
            }
            PubSubDAO.MAMItem mAMItem = null;
            this.data_repo.release(null, rs);
            return mAMItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSubscription(BareJID serviceJid, Long nodeId, BareJID jid) throws RepositoryException {
        HashCode hash = null;
        try {
            PreparedStatement delete_node_subscriptions_sp;
            hash = this.takeDao();
            PreparedStatement preparedStatement = delete_node_subscriptions_sp = this.data_repo.getPreparedStatement(hash.hashCode(), DELETE_NODE_SUBSCRIPTIONS_QUERY);
            synchronized (preparedStatement) {
                delete_node_subscriptions_sp.setLong(1, nodeId);
                delete_node_subscriptions_sp.setString(2, jid.toString());
                delete_node_subscriptions_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteService(BareJID serviceJid) throws RepositoryException {
        HashCode hash = null;
        try {
            PreparedStatement remove_service_sp;
            hash = this.takeDao();
            PreparedStatement preparedStatement = remove_service_sp = this.data_repo.getPreparedStatement(hash.hashCode(), REMOVE_SERVICE_QUERY);
            synchronized (preparedStatement) {
                remove_service_sp.setString(1, serviceJid.toString());
                remove_service_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAffiliation(BareJID serviceJid, Long nodeId, String nodeName, UsersAffiliation affiliation) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node affiliation[1]: " + nodeName + " / " + affiliation);
        }
        HashCode hash = null;
        try {
            PreparedStatement set_node_affiliations_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = set_node_affiliations_sp = this.data_repo.getPreparedStatement(hash.hashCode(), SET_NODE_AFFILIATION_QUERY);
            synchronized (preparedStatement) {
                try {
                    set_node_affiliations_sp.setLong(1, nodeId);
                    set_node_affiliations_sp.setString(2, affiliation.getJid().toString());
                    set_node_affiliations_sp.setString(3, affiliation.getAffiliation().name());
                    switch (this.data_repo.getDatabaseType()) {
                        case mysql: {
                            rs = set_node_affiliations_sp.executeQuery();
                            break;
                        }
                        default: {
                            set_node_affiliations_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node affiliation[2]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, Long nodeId, String serializedData, Long collectionId) throws RepositoryException {
        HashCode hash = null;
        try {
            PreparedStatement set_node_configuration_sp;
            hash = this.takeDao();
            ResultSet rs = null;
            PreparedStatement preparedStatement = set_node_configuration_sp = this.data_repo.getPreparedStatement(hash.hashCode(), SET_NODE_CONFIGURATION_QUERY);
            synchronized (preparedStatement) {
                try {
                    set_node_configuration_sp.setLong(1, nodeId);
                    set_node_configuration_sp.setString(2, serializedData);
                    if (collectionId == null) {
                        set_node_configuration_sp.setNull(3, -5);
                    } else {
                        set_node_configuration_sp.setLong(3, collectionId);
                    }
                    switch (this.data_repo.getDatabaseType()) {
                        case mysql: {
                            rs = set_node_configuration_sp.executeQuery();
                            break;
                        }
                        default: {
                            set_node_configuration_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node configuration writing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeSubscription(BareJID serviceJid, Long nodeId, String nodeName, UsersSubscription subscription) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node subscriptions[1]: " + nodeName + " / " + subscription);
        }
        HashCode hash = null;
        try {
            PreparedStatement set_node_subscriptions_sp;
            ResultSet rs = null;
            hash = this.takeDao();
            PreparedStatement preparedStatement = set_node_subscriptions_sp = this.data_repo.getPreparedStatement(hash.hashCode(), SET_NODE_SUBSCRIPTION_QUERY);
            synchronized (preparedStatement) {
                try {
                    set_node_subscriptions_sp.setLong(1, nodeId);
                    set_node_subscriptions_sp.setString(2, subscription.getJid().toString());
                    set_node_subscriptions_sp.setString(3, subscription.getSubscription().name());
                    set_node_subscriptions_sp.setString(4, subscription.getSubid());
                    switch (this.data_repo.getDatabaseType()) {
                        case mysql: {
                            rs = set_node_subscriptions_sp.executeQuery();
                            break;
                        }
                        default: {
                            set_node_subscriptions_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", (Throwable)e);
        }
        finally {
            this.offerDao(hash);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node subscriptions[2]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, Long nodeId, long timeInMilis, String id, String publisher, Element item, String uuid) throws RepositoryException {
        HashCode hash = null;
        try {
            JID jid;
            String publisherValue = publisher;
            if (publisher != null && this.data_repo.getDatabaseType() == DataRepository.dbTypes.mysql && (jid = JID.jidInstanceNS((String)publisher)).hasResource()) {
                String resource = Utils.removeMySQLNonUtf8mb3Codepoints(jid.getResource());
                publisherValue = JID.jidInstanceNS((BareJID)jid.getBareJID(), (String)resource).toString();
            }
            hash = this.takeDao();
            PreparedStatement write_item_sp = this.data_repo.getPreparedStatement(hash.hashCode(), WRITE_ITEM_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = write_item_sp;
            synchronized (preparedStatement) {
                try {
                    write_item_sp.setLong(1, nodeId);
                    write_item_sp.setString(2, id);
                    write_item_sp.setString(3, publisherValue);
                    write_item_sp.setString(4, item.toString());
                    this.data_repo.setTimestamp(write_item_sp, 5, new Timestamp(timeInMilis));
                    write_item_sp.setString(6, uuid);
                    write_item_sp.execute();
                }
                finally {
                    this.release(null, rs);
                }
            }
            this.offerDao(hash);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("Item writing error", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.offerDao(hash);
                throw throwable;
            }
        }
    }

    public void setDataSource(DataRepository dataSource) {
        try {
            this.initPreparedStatements(dataSource);
        }
        catch (SQLException ex) {
            new RuntimeException("Failed to initialize access to SQL database for PubSubDAOJDBC", ex);
        }
        this.data_repo = dataSource;
        int poolSize = dataSource.getPoolSize();
        for (int i = 0; i < poolSize; ++i) {
            this.pool_hashCodes.offer(new HashCode(dataSource, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer countMAMItems(ExtendedQueryImpl query, Long nodeId) throws TigaseDBException {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamQueryItemsCount);
            synchronized (preparedStatement) {
                ResultSet rs;
                block7: {
                    Integer n;
                    rs = null;
                    try {
                        this.setStatementParamsForMAM(st, query, nodeId);
                        rs = st.executeQuery();
                        if (!rs.next()) break block7;
                        n = rs.getInt(1);
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return n;
                }
                Integer n = null;
                this.data_repo.release(null, rs);
                return n;
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Failed to retrieve number of items for nodes at " + query.getComponentJID(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer getMAMItemPosition(ExtendedQueryImpl query, Long nodeId, String itemUuid) throws RepositoryException, ComponentException {
        if (itemUuid == null) {
            return null;
        }
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.data_repo.getPreparedStatement(query.getQuestionerJID().getBareJID(), this.mamQueryItemPosition);
            synchronized (preparedStatement) {
                block8: {
                    Integer n;
                    ResultSet rs = null;
                    try {
                        int i = this.setStatementParamsForMAM(st, query, nodeId);
                        st.setString(i++, itemUuid);
                        rs = st.executeQuery();
                        if (!rs.next()) break block8;
                        n = rs.getInt(1) - 1;
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return n;
                }
                throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Not found item with uuid = " + itemUuid);
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Can't find position for item with id " + itemUuid + " in archive for room " + query.getComponentJID(), (Throwable)ex);
        }
    }

    protected int setStatementParamsForMAM(PreparedStatement st, ExtendedQueryImpl query, Long nodeId) throws SQLException {
        int i = 1;
        st.setLong(i++, nodeId);
        this.data_repo.setTimestamp(st, i++, query.getStart() == null ? null : new Timestamp(query.getStart().getTime()));
        this.data_repo.setTimestamp(st, i++, query.getEnd() == null ? null : new Timestamp(query.getEnd().getTime()));
        return i;
    }

    protected HashCode takeDao() {
        try {
            return this.pool_hashCodes.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain PubSub DAO from the pool", ex);
            return null;
        }
    }

    protected void offerDao(HashCode hash) {
        if (hash != null && hash.canOffer()) {
            this.pool_hashCodes.offer(hash);
        }
    }

    private void initPreparedStatements(DataRepository data_repo) throws SQLException {
        data_repo.initPreparedStatement(CREATE_NODE_QUERY, CREATE_NODE_QUERY);
        data_repo.initPreparedStatement(REMOVE_NODE_QUERY, REMOVE_NODE_QUERY);
        data_repo.initPreparedStatement(CREATE_SERVICE_QUERY, CREATE_SERVICE_QUERY);
        data_repo.initPreparedStatement(REMOVE_SERVICE_QUERY, REMOVE_SERVICE_QUERY);
        data_repo.initPreparedStatement(GET_SERVICES_QUERY, GET_SERVICES_QUERY);
        data_repo.initPreparedStatement(GET_NODE_ID_QUERY, GET_NODE_ID_QUERY);
        data_repo.initPreparedStatement(GET_NODE_META_QUERY, GET_NODE_META_QUERY);
        data_repo.initPreparedStatement(GET_ITEM_QUERY, GET_ITEM_QUERY);
        data_repo.initPreparedStatement(WRITE_ITEM_QUERY, WRITE_ITEM_QUERY);
        data_repo.initPreparedStatement(DELETE_ITEM_QUERY, DELETE_ITEM_QUERY);
        data_repo.initPreparedStatement(GET_NODE_ITEM_IDS_QUERY, GET_NODE_ITEM_IDS_QUERY);
        data_repo.initPreparedStatement(GET_NODE_ITEM_IDS_SINCE_QUERY, GET_NODE_ITEM_IDS_SINCE_QUERY);
        data_repo.initPreparedStatement(GET_NODE_ITEMS_META_QUERY, GET_NODE_ITEMS_META_QUERY);
        data_repo.initPreparedStatement(COUNT_NODES_QUERY, COUNT_NODES_QUERY);
        data_repo.initPreparedStatement(GET_ALL_NODES_QUERY, GET_ALL_NODES_QUERY);
        data_repo.initPreparedStatement(GET_ROOT_NODES_QUERY, GET_ROOT_NODES_QUERY);
        data_repo.initPreparedStatement(GET_CHILD_NODES_QUERY, GET_CHILD_NODES_QUERY);
        data_repo.initPreparedStatement(SET_NODE_CONFIGURATION_QUERY, SET_NODE_CONFIGURATION_QUERY);
        data_repo.initPreparedStatement(SET_NODE_AFFILIATION_QUERY, SET_NODE_AFFILIATION_QUERY);
        data_repo.initPreparedStatement(GET_NODE_AFFILIATIONS_QUERY, GET_NODE_AFFILIATIONS_QUERY);
        data_repo.initPreparedStatement(GET_NODE_SUBSCRIPTIONS_QUERY, GET_NODE_SUBSCRIPTIONS_QUERY);
        data_repo.initPreparedStatement(SET_NODE_SUBSCRIPTION_QUERY, SET_NODE_SUBSCRIPTION_QUERY);
        data_repo.initPreparedStatement(DELETE_NODE_SUBSCRIPTIONS_QUERY, DELETE_NODE_SUBSCRIPTIONS_QUERY);
        data_repo.initPreparedStatement(GET_USER_AFFILIATIONS_QUERY, GET_USER_AFFILIATIONS_QUERY);
        data_repo.initPreparedStatement(GET_USER_SUBSCRIPTIONS_QUERY, GET_USER_SUBSCRIPTIONS_QUERY);
        data_repo.initPreparedStatement(COUNT_NODES_ITEMS_QUERY, COUNT_NODES_ITEMS_QUERY);
        data_repo.initPreparedStatement(GET_NODES_ITEMS_QUERY, GET_NODES_ITEMS_QUERY);
        data_repo.initPreparedStatement(GET_NODES_ITEMS_POSITION_QUERY, GET_NODES_ITEMS_POSITION_QUERY);
        data_repo.initPreparedStatement(this.mamAddItem, this.mamAddItem);
        data_repo.initPreparedStatement(this.mamUpdateItem, this.mamUpdateItem);
        data_repo.initPreparedStatement(this.mamQueryItem, this.mamQueryItem);
        data_repo.initPreparedStatement(this.mamQueryItems, this.mamQueryItems);
        data_repo.initPreparedStatement(this.mamQueryItemPosition, this.mamQueryItemPosition);
        data_repo.initPreparedStatement(this.mamQueryItemsCount, this.mamQueryItemsCount);
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class HashCode {
        private final int hash;
        private final int repoHash;

        public HashCode(DataRepository dataRepository, int connNo) {
            this.hash = connNo;
            this.repoHash = dataRepository.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean canOffer() {
            return PubSubDAOJDBC.this.data_repo.hashCode() == this.repoHash;
        }
    }

    private static class IItemsItem
    extends IItems.Item {
        private final long nodeId;

        public IItemsItem(String node, long nodeId, String id, String uuid, Element item) {
            super(node, id, uuid, item);
            this.nodeId = nodeId;
        }

        public long getNodeId() {
            return this.nodeId;
        }

        public String getRsmId() {
            return this.nodeId + "#" + this.getId();
        }

        public static long getNodeIdFromRsmId(String rsmId) {
            int idx = rsmId.indexOf(35);
            if (idx <= 0) {
                return 0L;
            }
            return Long.parseLong(rsmId.substring(0, idx - 1));
        }

        public static String getItemIdFromRsmId(String rsmId) {
            int idx = rsmId.indexOf(35);
            if (idx <= 0 || rsmId.length() < idx + 1) {
                return rsmId;
            }
            return rsmId.substring(idx + 1);
        }
    }
}

