/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.BasicComponent;
import tigase.xml.Element;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.rsm.RSM;

@Bean(name="dao", parent=PubSubComponent.class, active=true)
public class PubSubDAOPool<T, S extends DataSource, Q extends PubSubQuery>
extends MDRepositoryBeanWithStatistics<IPubSubDAO<T, S, Q>>
implements IPubSubDAO<T, S, Q> {
    private static final Logger log = Logger.getLogger(PubSubDAOPool.class.getName());
    private boolean destroyed = false;
    @ConfigField(desc="Use same domain to lookup for PEP nodes and component nodes")
    private boolean mapComponentToBareDomain = false;

    public PubSubDAOPool() {
        super(new Class[]{IPubSubDAO.class});
    }

    public boolean belongsTo(Class<? extends BasicComponent> component) {
        return PubSubComponent.class.isAssignableFrom(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, T collectionId, boolean autocreateService) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                T t = dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId, autocreateService);
                return t;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createService(BareJID serviceJID, boolean isPublic) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJID);
        if (dao != null) {
            try {
                dao.createService(serviceJID, isPublic);
            }
            finally {
                this.offerDao(serviceJID, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BareJID> getServices(BareJID domain, Boolean isPublic) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(domain);
        if (dao != null) {
            try {
                List<BareJID> list = dao.getServices(domain, isPublic);
                return list;
            }
            finally {
                this.offerDao(domain, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(domain));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, T nodeId, String id) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteItem(serviceJid, nodeId, id);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, T nodeId) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteNode(serviceJid, nodeId);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    @Override
    public void destroy() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "destroying IPubSubDAOPool {0}", this);
        }
        this.destroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getAllNodesList(serviceJid);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getChildNodes(serviceJid, nodeName);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IItems.IItem getItem(BareJID serviceJid, T nodeId, String id) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                IItems.IItem iItem = dao.getItem(serviceJid, nodeId, id);
                return iItem;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.IItem> getItems(BareJID serviceJid, List<T> nodesIds, Date after, Date before, RSM rsm, CollectionItemsOrdering ordering) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                List<IItems.IItem> list = dao.getItems(serviceJid, nodesIds, after, before, rsm, ordering);
                return list;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, T nodeId, CollectionItemsOrdering order) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIds(serviceJid, nodeId, order);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIdsSince(BareJID serviceJid, T nodeId, CollectionItemsOrdering order, Date since) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIdsSince(serviceJid, nodeId, order, since);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, T nodeId, String nodeName) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                List<IItems.ItemMeta> list = dao.getItemsMeta(serviceJid, nodeId, nodeName);
                return list;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, UsersAffiliation> getNodeAffiliations(BareJID serviceJid, T nodeId) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<BareJID, UsersAffiliation> map = dao.getNodeAffiliations(serviceJid, nodeId);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INodeMeta<T> getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                INodeMeta iNodeMeta = dao.getNodeMeta(serviceJid, nodeName);
                return iNodeMeta;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodesCount(BareJID serviceJid) throws RepositoryException {
        if (serviceJid != null) {
            IPubSubDAO dao = this.takeDao(serviceJid);
            if (dao != null) {
                try {
                    long l = dao.getNodesCount(serviceJid);
                    return l;
                }
                finally {
                    this.offerDao(serviceJid, dao);
                }
            }
            return 0L;
        }
        long count = 0L;
        for (IPubSubDAO dao : this.getRepositories().values()) {
            count += dao.getNodesCount(serviceJid);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getNodesList(serviceJid, nodeName);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, UsersSubscription> getNodeSubscriptions(BareJID serviceJid, T nodeId) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<BareJID, UsersSubscription> map = dao.getNodeSubscriptions(serviceJid, nodeId);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<String, UsersAffiliation> map = dao.getUserAffiliations(serviceJid, jid);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(null);
        if (dao != null) {
            return dao.getUserRoster(owner);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Map<String, UsersSubscription> map = dao.getUserSubscriptions(serviceJid, jid);
                return map;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    @Override
    public AbstractNodeConfig parseConfig(String nodeName, String cfgData) throws RepositoryException {
        return null;
    }

    @Override
    public void addMAMItem(BareJID serviceJid, T nodeId, String uuid, Element message, String itemId) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            dao.addMAMItem(serviceJid, nodeId, uuid, message, itemId);
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    @Override
    public Q newQuery(BareJID serviceJid) {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            return dao.newQuery(serviceJid);
        }
        return (Q)new Query();
    }

    @Override
    public void queryItems(Q query, T nodeId, MAMRepository.ItemHandler<Q, MAMRepository.Item> itemHandler) throws RepositoryException, ComponentException {
        BareJID serviceJid = query.getComponentJID().getBareJID();
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            dao.queryItems(query, nodeId, itemHandler);
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSubscription(BareJID serviceJid, T nodeId, BareJID jid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeNodeSubscription(serviceJid, nodeId, jid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    public IPubSubDAO takeDao(BareJID serviceJid) {
        int idx;
        if (serviceJid == null) {
            return (IPubSubDAO)this.getRepository("default");
        }
        if (this.mapComponentToBareDomain && serviceJid.getLocalpart() == null && (idx = serviceJid.getDomain().indexOf(".")) > 0) {
            String basename = serviceJid.getDomain().substring(idx + 1);
            return (IPubSubDAO)this.getRepository(basename);
        }
        return (IPubSubDAO)this.getRepository(serviceJid.getDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAffiliation(BareJID serviceJid, T nodeId, String nodeName, UsersAffiliation affiliation) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeAffiliation(serviceJid, nodeId, nodeName, affiliation);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, T nodeId, String serializedData, T collectionId) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeConfig(serviceJid, nodeId, serializedData, collectionId);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeSubscription(BareJID serviceJid, T nodeId, String nodeName, UsersSubscription subscription) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeSubscription(serviceJid, nodeId, nodeName, subscription);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, T nodeId, long timeInMilis, String id, String publisher, Element item, String uuid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.writeItem(serviceJid, nodeId, timeInMilis, id, publisher, item, uuid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    @Override
    public void deleteService(BareJID serviceJid) throws RepositoryException {
        IPubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteService(serviceJid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    public void setDataSource(DataSource dataSource) {
    }

    public Class<?> getDefaultBeanClass() {
        return PubSubDAOConfigBean.class;
    }

    @Deprecated
    protected String getPoolDetails(BareJID serviceJid) {
        return "";
    }

    @Deprecated
    protected void offerDao(BareJID serviceJid, IPubSubDAO dao) {
        if (this.destroyed) {
            dao.destroy();
            return;
        }
    }

    protected Class<? extends IPubSubDAO<T, S, Q>> findClassForDataSource(DataSource dataSource) throws DBInitException {
        Class cls = DataSourceHelper.getDefaultClass(PubSubDAO.class, (String)dataSource.getResourceUri());
        return cls;
    }

    public static class PubSubDAOConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<IPubSubDAO> {
    }
}

