/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="nodeDeleteModule", parent=PubSubComponent.class, active=true)
public class NodeDeleteModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_DELETE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"delete"));
    @Inject
    private EventBus eventBus;
    @Inject
    private PublishItemModule publishModule;

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#delete-nodes"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_DELETE;
    }

    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
        Element delete = pubSub.getChild("delete");
        String nodeName = delete.getAttributeStaticStr("node");
        try {
            String parentNodeName;
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.NOT_ALLOWED);
            }
            JID jid = packet.getStanzaFrom();
            this.pubSubLogic.checkPermission(toJid, nodeName, jid, PubSubLogic.Action.manageNode);
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            Packet result = packet.okResult((Element)null, 0);
            if (nodeConfig.isNotify_config()) {
                Element del = new Element("delete", new String[]{"node"}, new String[]{nodeName});
                this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), nodeName, del, null, false);
            }
            if ((parentNodeName = nodeConfig.getCollection()) == null || "".equals(parentNodeName)) {
                this.getRepository().removeFromRootCollection(toJid, nodeName);
            }
            if (nodeConfig instanceof CollectionNodeConfig) {
                CollectionNodeConfig cnc = (CollectionNodeConfig)nodeConfig;
                String[] childrenNodes = this.getRepository().getChildNodes(toJid, nodeName);
                if (childrenNodes != null && childrenNodes.length > 0) {
                    for (String childNodeName : childrenNodes) {
                        AbstractNodeConfig childNodeConfig = this.getRepository().getNodeConfig(toJid, childNodeName);
                        if (childNodeConfig != null) {
                            childNodeConfig.setCollection(parentNodeName);
                            this.getRepository().update(toJid, childNodeName, childNodeConfig);
                        }
                        if (parentNodeName != null && !"".equals(parentNodeName)) continue;
                        this.getRepository().addToRootCollection(toJid, childNodeName);
                    }
                }
            }
            log.fine("Delete node [" + nodeName + "]");
            this.getRepository().deleteNode(toJid, nodeName);
            this.eventBus.fire((Object)new NodeDeletedEvent(this.config.getComponentName(), toJid, nodeName));
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing node delete packet", e);
            throw new RuntimeException(e);
        }
    }

    public static class NodeDeletedEvent {
        public final String componentName;
        public final String node;
        public final BareJID serviceJid;

        public NodeDeletedEvent(String componentName, BareJID serviceJid, String node) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.node = node;
        }
    }
}

